/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAutoScalingNotificationTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAutoScalingNotificationTypesResponse.Builder, DescribeAutoScalingNotificationTypesResponse> {
    private final List<String> autoScalingNotificationTypes;

    private DescribeAutoScalingNotificationTypesResponse(BuilderImpl builder) {
        this.autoScalingNotificationTypes = builder.autoScalingNotificationTypes;
    }

    /**
     * <p>
     * The notification types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The notification types.
     */
    public List<String> autoScalingNotificationTypes() {
        return autoScalingNotificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingNotificationTypes() == null) ? 0 : autoScalingNotificationTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingNotificationTypesResponse)) {
            return false;
        }
        DescribeAutoScalingNotificationTypesResponse other = (DescribeAutoScalingNotificationTypesResponse) obj;
        if (other.autoScalingNotificationTypes() == null ^ this.autoScalingNotificationTypes() == null) {
            return false;
        }
        if (other.autoScalingNotificationTypes() != null
                && !other.autoScalingNotificationTypes().equals(this.autoScalingNotificationTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingNotificationTypes() != null) {
            sb.append("AutoScalingNotificationTypes: ").append(autoScalingNotificationTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingNotificationTypes":
            return Optional.of(clazz.cast(autoScalingNotificationTypes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes);

        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> autoScalingNotificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingNotificationTypesResponse model) {
            autoScalingNotificationTypes(model.autoScalingNotificationTypes);
        }

        public final Collection<String> getAutoScalingNotificationTypes() {
            return autoScalingNotificationTypes;
        }

        @Override
        public final Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes) {
            autoScalingNotificationTypes(Arrays.asList(autoScalingNotificationTypes));
            return this;
        }

        public final void setAutoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
        }

        @Override
        public DescribeAutoScalingNotificationTypesResponse build() {
            return new DescribeAutoScalingNotificationTypesResponse(this);
        }
    }
}
