/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScalingProcessTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeScalingProcessTypesResponse.Builder, DescribeScalingProcessTypesResponse> {
    private final List<ProcessType> processes;

    private DescribeScalingProcessTypesResponse(BuilderImpl builder) {
        this.processes = builder.processes;
    }

    /**
     * <p>
     * The names of the process types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the process types.
     */
    public List<ProcessType> processes() {
        return processes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((processes() == null) ? 0 : processes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResponse)) {
            return false;
        }
        DescribeScalingProcessTypesResponse other = (DescribeScalingProcessTypesResponse) obj;
        if (other.processes() == null ^ this.processes() == null) {
            return false;
        }
        if (other.processes() != null && !other.processes().equals(this.processes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (processes() != null) {
            sb.append("Processes: ").append(processes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Processes":
            return Optional.of(clazz.cast(processes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
        /**
         * <p>
         * The names of the process types.
         * </p>
         * 
         * @param processes
         *        The names of the process types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processes(Collection<ProcessType> processes);

        /**
         * <p>
         * The names of the process types.
         * </p>
         * 
         * @param processes
         *        The names of the process types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processes(ProcessType... processes);
    }

    static final class BuilderImpl implements Builder {
        private List<ProcessType> processes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingProcessTypesResponse model) {
            processes(model.processes);
        }

        public final Collection<ProcessType.Builder> getProcesses() {
            return processes != null ? processes.stream().map(ProcessType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processes(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(ProcessType... processes) {
            processes(Arrays.asList(processes));
            return this;
        }

        public final void setProcesses(Collection<ProcessType.BuilderImpl> processes) {
            this.processes = ProcessesCopier.copyFromBuilder(processes);
        }

        @Override
        public DescribeScalingProcessTypesResponse build() {
            return new DescribeScalingProcessTypesResponse(this);
        }
    }
}
