/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachLoadBalancerTargetGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachLoadBalancerTargetGroupsRequest.Builder, DetachLoadBalancerTargetGroupsRequest> {
    private final String autoScalingGroupName;

    private final List<String> targetGroupARNs;

    private DetachLoadBalancerTargetGroupsRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.targetGroupARNs = builder.targetGroupARNs;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the target groups.
     */
    public List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((targetGroupARNs() == null) ? 0 : targetGroupARNs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancerTargetGroupsRequest)) {
            return false;
        }
        DetachLoadBalancerTargetGroupsRequest other = (DetachLoadBalancerTargetGroupsRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.targetGroupARNs() == null ^ this.targetGroupARNs() == null) {
            return false;
        }
        if (other.targetGroupARNs() != null && !other.targetGroupARNs().equals(this.targetGroupARNs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(targetGroupARNs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "TargetGroupARNs":
            return Optional.of(clazz.cast(targetGroupARNs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetachLoadBalancerTargetGroupsRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> targetGroupARNs;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachLoadBalancerTargetGroupsRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            targetGroupARNs(model.targetGroupARNs);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getTargetGroupARNs() {
            return targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public DetachLoadBalancerTargetGroupsRequest build() {
            return new DetachLoadBalancerTargetGroupsRequest(this);
        }
    }
}
