/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DisableMetricsCollectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DisableMetricsCollectionRequest.Builder, DisableMetricsCollectionRequest> {
    private final String autoScalingGroupName;

    private final List<String> metrics;

    private DisableMetricsCollectionRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more of the following metrics. If you omit this parameter, all metrics are disabled.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GroupMinSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupMaxSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalInstances</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more of the following metrics. If you omit this parameter, all metrics are disabled.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GroupMinSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupMaxSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalInstances</code>
     *         </p>
     *         </li>
     */
    public List<String> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((metrics() == null) ? 0 : metrics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableMetricsCollectionRequest)) {
            return false;
        }
        DisableMetricsCollectionRequest other = (DisableMetricsCollectionRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (metrics() != null) {
            sb.append("Metrics: ").append(metrics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "Metrics":
            return Optional.of(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DisableMetricsCollectionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following metrics. If you omit this parameter, all metrics are disabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        One or more of the following metrics. If you omit this parameter, all metrics are disabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * One or more of the following metrics. If you omit this parameter, all metrics are disabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        One or more of the following metrics. If you omit this parameter, all metrics are disabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableMetricsCollectionRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            metrics(model.metrics);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @Override
        public DisableMetricsCollectionRequest build() {
            return new DisableMetricsCollectionRequest(this);
        }
    }
}
