/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ExecutePolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ExecutePolicyRequest.Builder, ExecutePolicyRequest> {
    private final String autoScalingGroupName;

    private final String policyName;

    private final Boolean honorCooldown;

    private final Double metricValue;

    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name or ARN of the policy.
     * </p>
     * 
     * @return The name or ARN of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the policy.
     * Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to complete.
     * </p>
     * <p>
     * This parameter is not supported if the policy type is <code>StepScaling</code>.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
     *         policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to
     *         complete.</p>
     *         <p>
     *         This parameter is not supported if the policy type is <code>StepScaling</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Boolean honorCooldown() {
        return honorCooldown;
    }

    /**
     * <p>
     * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50
     * and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric
     * value to 59.
     * </p>
     * <p>
     * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an
     * error.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     *         <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold
     *         is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set
     *         the metric value to 59.</p>
     *         <p>
     *         If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
     *         returns an error.
     *         </p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public Double metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The breach threshold for the alarm.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The breach threshold for the alarm.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public Double breachThreshold() {
        return breachThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((honorCooldown() == null) ? 0 : honorCooldown().hashCode());
        hashCode = 31 * hashCode + ((metricValue() == null) ? 0 : metricValue().hashCode());
        hashCode = 31 * hashCode + ((breachThreshold() == null) ? 0 : breachThreshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.honorCooldown() == null ^ this.honorCooldown() == null) {
            return false;
        }
        if (other.honorCooldown() != null && !other.honorCooldown().equals(this.honorCooldown())) {
            return false;
        }
        if (other.metricValue() == null ^ this.metricValue() == null) {
            return false;
        }
        if (other.metricValue() != null && !other.metricValue().equals(this.metricValue())) {
            return false;
        }
        if (other.breachThreshold() == null ^ this.breachThreshold() == null) {
            return false;
        }
        if (other.breachThreshold() != null && !other.breachThreshold().equals(this.breachThreshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (honorCooldown() != null) {
            sb.append("HonorCooldown: ").append(honorCooldown()).append(",");
        }
        if (metricValue() != null) {
            sb.append("MetricValue: ").append(metricValue()).append(",");
        }
        if (breachThreshold() != null) {
            sb.append("BreachThreshold: ").append(breachThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.of(clazz.cast(policyName()));
        case "HonorCooldown":
            return Optional.of(clazz.cast(honorCooldown()));
        case "MetricValue":
            return Optional.of(clazz.cast(metricValue()));
        case "BreachThreshold":
            return Optional.of(clazz.cast(breachThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExecutePolicyRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name or ARN of the policy.
         * </p>
         * 
         * @param policyName
         *        The name or ARN of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
         * policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to complete.
         * </p>
         * <p>
         * This parameter is not supported if the policy type is <code>StepScaling</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param honorCooldown
         *        If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
         *        policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to
         *        complete.</p>
         *        <p>
         *        This parameter is not supported if the policy type is <code>StepScaling</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorCooldown(Boolean honorCooldown);

        /**
         * <p>
         * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
         * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is
         * 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the
         * metric value to 59.
         * </p>
         * <p>
         * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns
         * an error.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param metricValue
         *        The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of
         *        type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach
         *        threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of
         *        10, you can set the metric value to 59.</p>
         *        <p>
         *        If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
         *        returns an error.
         *        </p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(Double metricValue);

        /**
         * <p>
         * The breach threshold for the alarm.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param breachThreshold
         *        The breach threshold for the alarm.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breachThreshold(Double breachThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private Boolean honorCooldown;

        private Double metricValue;

        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            honorCooldown(model.honorCooldown);
            metricValue(model.metricValue);
            breachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Boolean getHonorCooldown() {
            return honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        public final Double getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getBreachThreshold() {
            return breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }
    }
}
