/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements ToCopyableBuilder<Instance.Builder, Instance> {
    private final String instanceId;

    private final String availabilityZone;

    private final String lifecycleState;

    private final String healthStatus;

    private final String launchConfigurationName;

    private final Boolean protectedFromScaleIn;

    private Instance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Availability Zone in which the instance is running.
     * </p>
     * 
     * @return The Availability Zone in which the instance is running.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link LifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStateString}.
     * </p>
     * 
     * @return A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
     * @see LifecycleState
     */
    public LifecycleState lifecycleState() {
        return LifecycleState.fromValue(lifecycleState);
    }

    /**
     * <p>
     * A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link LifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStateString}.
     * </p>
     * 
     * @return A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
     * @see LifecycleState
     */
    public String lifecycleStateString() {
        return lifecycleState;
    }

    /**
     * <p>
     * The last reported health status of the instance. "Healthy" means that the instance is healthy and should remain
     * in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and replace it.
     * </p>
     * 
     * @return The last reported health status of the instance. "Healthy" means that the instance is healthy and should
     *         remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and
     *         replace it.
     */
    public String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * The launch configuration associated with the instance.
     * </p>
     * 
     * @return The launch configuration associated with the instance.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     */
    public Boolean protectedFromScaleIn() {
        return protectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((lifecycleStateString() == null) ? 0 : lifecycleStateString().hashCode());
        hashCode = 31 * hashCode + ((healthStatus() == null) ? 0 : healthStatus().hashCode());
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((protectedFromScaleIn() == null) ? 0 : protectedFromScaleIn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.lifecycleStateString() == null ^ this.lifecycleStateString() == null) {
            return false;
        }
        if (other.lifecycleStateString() != null && !other.lifecycleStateString().equals(this.lifecycleStateString())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.protectedFromScaleIn() == null ^ this.protectedFromScaleIn() == null) {
            return false;
        }
        if (other.protectedFromScaleIn() != null && !other.protectedFromScaleIn().equals(this.protectedFromScaleIn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (lifecycleStateString() != null) {
            sb.append("LifecycleState: ").append(lifecycleStateString()).append(",");
        }
        if (healthStatus() != null) {
            sb.append("HealthStatus: ").append(healthStatus()).append(",");
        }
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (protectedFromScaleIn() != null) {
            sb.append("ProtectedFromScaleIn: ").append(protectedFromScaleIn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "LifecycleState":
            return Optional.of(clazz.cast(lifecycleStateString()));
        case "HealthStatus":
            return Optional.of(clazz.cast(healthStatus()));
        case "LaunchConfigurationName":
            return Optional.of(clazz.cast(launchConfigurationName()));
        case "ProtectedFromScaleIn":
            return Optional.of(clazz.cast(protectedFromScaleIn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Availability Zone in which the instance is running.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
         * </p>
         * 
         * @param lifecycleState
         *        A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not
         *        used.
         * @see LifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleState
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not used.
         * </p>
         * 
         * @param lifecycleState
         *        A description of the current lifecycle state. Note that the <code>Quarantined</code> state is not
         *        used.
         * @see LifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecycleState
         */
        Builder lifecycleState(LifecycleState lifecycleState);

        /**
         * <p>
         * The last reported health status of the instance. "Healthy" means that the instance is healthy and should
         * remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and
         * replace it.
         * </p>
         * 
         * @param healthStatus
         *        The last reported health status of the instance. "Healthy" means that the instance is healthy and
         *        should remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should
         *        terminate and replace it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The launch configuration associated with the instance.
         * </p>
         * 
         * @param launchConfigurationName
         *        The launch configuration associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param protectedFromScaleIn
         *        Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedFromScaleIn(Boolean protectedFromScaleIn);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String availabilityZone;

        private String lifecycleState;

        private String healthStatus;

        private String launchConfigurationName;

        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            instanceId(model.instanceId);
            availabilityZone(model.availabilityZone);
            lifecycleState(model.lifecycleState);
            healthStatus(model.healthStatus);
            launchConfigurationName(model.launchConfigurationName);
            protectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState.toString());
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
