/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a target group.
 * </p>
 * <p>
 * If you attach a target group to an existing Auto Scaling group, the initial state is <code>Adding</code>. The state
 * transitions to <code>Added</code> after all Auto Scaling instances are registered with the target group. If ELB
 * health checks are enabled, the state transitions to <code>InService</code> after at least one Auto Scaling instance
 * passes the health check. If EC2 health checks are enabled instead, the target group remains in the <code>Added</code>
 * state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadBalancerTargetGroupState implements
        ToCopyableBuilder<LoadBalancerTargetGroupState.Builder, LoadBalancerTargetGroupState> {
    private final String loadBalancerTargetGroupARN;

    private final String state;

    private LoadBalancerTargetGroupState(BuilderImpl builder) {
        this.loadBalancerTargetGroupARN = builder.loadBalancerTargetGroupARN;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public String loadBalancerTargetGroupARN() {
        return loadBalancerTargetGroupARN;
    }

    /**
     * <p>
     * The state of the target group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Added</code> - All Auto Scaling instances are registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If connection
     * draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the
     * instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state of the target group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Added</code> - All Auto Scaling instances are registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
     *         connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
     *         deregistering the instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     *         </p>
     *         </li>
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((loadBalancerTargetGroupARN() == null) ? 0 : loadBalancerTargetGroupARN().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTargetGroupState)) {
            return false;
        }
        LoadBalancerTargetGroupState other = (LoadBalancerTargetGroupState) obj;
        if (other.loadBalancerTargetGroupARN() == null ^ this.loadBalancerTargetGroupARN() == null) {
            return false;
        }
        if (other.loadBalancerTargetGroupARN() != null
                && !other.loadBalancerTargetGroupARN().equals(this.loadBalancerTargetGroupARN())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (loadBalancerTargetGroupARN() != null) {
            sb.append("LoadBalancerTargetGroupARN: ").append(loadBalancerTargetGroupARN()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerTargetGroupARN":
            return Optional.of(clazz.cast(loadBalancerTargetGroupARN()));
        case "State":
            return Optional.of(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBalancerTargetGroupState> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param loadBalancerTargetGroupARN
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroupARN(String loadBalancerTargetGroupARN);

        /**
         * <p>
         * The state of the target group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Added</code> - All Auto Scaling instances are registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         * connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         * deregistering the instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the target group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Added</code> - All Auto Scaling instances are registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         *        connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         *        deregistering the instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String loadBalancerTargetGroupARN;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTargetGroupState model) {
            loadBalancerTargetGroupARN(model.loadBalancerTargetGroupARN);
            state(model.state);
        }

        public final String getLoadBalancerTargetGroupARN() {
            return loadBalancerTargetGroupARN;
        }

        @Override
        public final Builder loadBalancerTargetGroupARN(String loadBalancerTargetGroupARN) {
            this.loadBalancerTargetGroupARN = loadBalancerTargetGroupARN;
            return this;
        }

        public final void setLoadBalancerTargetGroupARN(String loadBalancerTargetGroupARN) {
            this.loadBalancerTargetGroupARN = loadBalancerTargetGroupARN;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public LoadBalancerTargetGroupState build() {
            return new LoadBalancerTargetGroupState(this);
        }
    }
}
