/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricCollectionType implements ToCopyableBuilder<MetricCollectionType.Builder, MetricCollectionType> {
    private final String metric;

    private MetricCollectionType(BuilderImpl builder) {
        this.metric = builder.metric;
    }

    /**
     * <p>
     * One of the following metrics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GroupMinSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupMaxSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalInstances</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following metrics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GroupMinSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupMaxSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalInstances</code>
     *         </p>
     *         </li>
     */
    public String metric() {
        return metric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metric() == null) ? 0 : metric().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricCollectionType)) {
            return false;
        }
        MetricCollectionType other = (MetricCollectionType) obj;
        if (other.metric() == null ^ this.metric() == null) {
            return false;
        }
        if (other.metric() != null && !other.metric().equals(this.metric())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (metric() != null) {
            sb.append("Metric: ").append(metric()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.of(clazz.cast(metric()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MetricCollectionType> {
        /**
         * <p>
         * One of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metric
         *        One of the following metrics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);
    }

    static final class BuilderImpl implements Builder {
        private String metric;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricCollectionType model) {
            metric(model.metric);
        }

        public final String getMetric() {
            return metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public MetricCollectionType build() {
            return new MetricCollectionType(this);
        }
    }
}
