/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a granularity of a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricGranularityType implements ToCopyableBuilder<MetricGranularityType.Builder, MetricGranularityType> {
    private final String granularity;

    private MetricGranularityType(BuilderImpl builder) {
        this.granularity = builder.granularity;
    }

    /**
     * <p>
     * The granularity. The only valid value is <code>1Minute</code>.
     * </p>
     * 
     * @return The granularity. The only valid value is <code>1Minute</code>.
     */
    public String granularity() {
        return granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((granularity() == null) ? 0 : granularity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricGranularityType)) {
            return false;
        }
        MetricGranularityType other = (MetricGranularityType) obj;
        if (other.granularity() == null ^ this.granularity() == null) {
            return false;
        }
        if (other.granularity() != null && !other.granularity().equals(this.granularity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (granularity() != null) {
            sb.append("Granularity: ").append(granularity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Granularity":
            return Optional.of(clazz.cast(granularity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, MetricGranularityType> {
        /**
         * <p>
         * The granularity. The only valid value is <code>1Minute</code>.
         * </p>
         * 
         * @param granularity
         *        The granularity. The only valid value is <code>1Minute</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularity(String granularity);
    }

    static final class BuilderImpl implements Builder {
        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricGranularityType model) {
            granularity(model.granularity);
        }

        public final String getGranularity() {
            return granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public MetricGranularityType build() {
            return new MetricGranularityType(this);
        }
    }
}
