/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScalingPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutScalingPolicyRequest.Builder, PutScalingPolicyRequest> {
    private final String autoScalingGroupName;

    private final String policyName;

    private final String policyType;

    private final String adjustmentType;

    private final Integer minAdjustmentStep;

    private final Integer minAdjustmentMagnitude;

    private final Integer scalingAdjustment;

    private final Integer cooldown;

    private final String metricAggregationType;

    private final List<StepAdjustment> stepAdjustments;

    private final Integer estimatedInstanceWarmup;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
    }

    /**
     * <p>
     * The name or ARN of the group.
     * </p>
     * 
     * @return The name or ARN of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>. If the policy type is
     * null, the value is treated as <code>SimpleScaling</code>.
     * </p>
     * 
     * @return The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>. If the policy
     *         type is null, the value is treated as <code>SimpleScaling</code>.
     */
    public String policyType() {
        return policyType;
    }

    /**
     * <p>
     * The adjustment type. Valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     * <code>PercentChangeInCapacity</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic Scaling</a>
     * in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The adjustment type. Valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     *         <code>PercentChangeInCapacity</code>.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
     *         Scaling</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    /**
     * <p>
     * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     * </p>
     * 
     * @return Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     */
    public Integer minAdjustmentStep() {
        return minAdjustmentStep;
    }

    /**
     * <p>
     * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
     * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     * </p>
     * 
     * @return The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     *         <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the
     *         Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     */
    public Integer minAdjustmentMagnitude() {
        return minAdjustmentMagnitude;
    }

    /**
     * <p>
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
     * capacity while a negative number removes from the current capacity.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The amount by which to scale, based on the specified adjustment type. A positive value adds to the
     *         current capacity while a negative number removes from the current capacity.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can
     * start. If this parameter is not specified, the default cooldown period for the group applies.
     * </p>
     * <p>
     * This parameter is not supported unless the policy type is <code>SimpleScaling</code>.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes and before the next scaling activity
     *         can start. If this parameter is not specified, the default cooldown period for the group applies.</p>
     *         <p>
     *         This parameter is not supported unless the policy type is <code>SimpleScaling</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Integer cooldown() {
        return cooldown;
    }

    /**
     * <p>
     * The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.
     * </p>
     * <p>
     * This parameter is not supported if the policy type is <code>SimpleScaling</code>.
     * </p>
     * 
     * @return The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
     *         <code>Average</code>.</p>
     *         <p>
     *         This parameter is not supported if the policy type is <code>SimpleScaling</code>.
     */
    public String metricAggregationType() {
        return metricAggregationType;
    }

    /**
     * <p>
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public List<StepAdjustment> stepAdjustments() {
        return stepAdjustments;
    }

    /**
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
     * default is to use the value specified for the default cooldown period for the group.
     * </p>
     * <p>
     * This parameter is not supported if the policy type is <code>SimpleScaling</code>.
     * </p>
     * 
     * @return The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     *         The default is to use the value specified for the default cooldown period for the group.</p>
     *         <p>
     *         This parameter is not supported if the policy type is <code>SimpleScaling</code>.
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policyType() == null) ? 0 : policyType().hashCode());
        hashCode = 31 * hashCode + ((adjustmentType() == null) ? 0 : adjustmentType().hashCode());
        hashCode = 31 * hashCode + ((minAdjustmentStep() == null) ? 0 : minAdjustmentStep().hashCode());
        hashCode = 31 * hashCode + ((minAdjustmentMagnitude() == null) ? 0 : minAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + ((scalingAdjustment() == null) ? 0 : scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + ((cooldown() == null) ? 0 : cooldown().hashCode());
        hashCode = 31 * hashCode + ((metricAggregationType() == null) ? 0 : metricAggregationType().hashCode());
        hashCode = 31 * hashCode + ((stepAdjustments() == null) ? 0 : stepAdjustments().hashCode());
        hashCode = 31 * hashCode + ((estimatedInstanceWarmup() == null) ? 0 : estimatedInstanceWarmup().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyType() == null ^ this.policyType() == null) {
            return false;
        }
        if (other.policyType() != null && !other.policyType().equals(this.policyType())) {
            return false;
        }
        if (other.adjustmentType() == null ^ this.adjustmentType() == null) {
            return false;
        }
        if (other.adjustmentType() != null && !other.adjustmentType().equals(this.adjustmentType())) {
            return false;
        }
        if (other.minAdjustmentStep() == null ^ this.minAdjustmentStep() == null) {
            return false;
        }
        if (other.minAdjustmentStep() != null && !other.minAdjustmentStep().equals(this.minAdjustmentStep())) {
            return false;
        }
        if (other.minAdjustmentMagnitude() == null ^ this.minAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.minAdjustmentMagnitude() != null && !other.minAdjustmentMagnitude().equals(this.minAdjustmentMagnitude())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.cooldown() == null ^ this.cooldown() == null) {
            return false;
        }
        if (other.cooldown() != null && !other.cooldown().equals(this.cooldown())) {
            return false;
        }
        if (other.metricAggregationType() == null ^ this.metricAggregationType() == null) {
            return false;
        }
        if (other.metricAggregationType() != null && !other.metricAggregationType().equals(this.metricAggregationType())) {
            return false;
        }
        if (other.stepAdjustments() == null ^ this.stepAdjustments() == null) {
            return false;
        }
        if (other.stepAdjustments() != null && !other.stepAdjustments().equals(this.stepAdjustments())) {
            return false;
        }
        if (other.estimatedInstanceWarmup() == null ^ this.estimatedInstanceWarmup() == null) {
            return false;
        }
        if (other.estimatedInstanceWarmup() != null && !other.estimatedInstanceWarmup().equals(this.estimatedInstanceWarmup())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyType() != null) {
            sb.append("PolicyType: ").append(policyType()).append(",");
        }
        if (adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(adjustmentType()).append(",");
        }
        if (minAdjustmentStep() != null) {
            sb.append("MinAdjustmentStep: ").append(minAdjustmentStep()).append(",");
        }
        if (minAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(minAdjustmentMagnitude()).append(",");
        }
        if (scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(scalingAdjustment()).append(",");
        }
        if (cooldown() != null) {
            sb.append("Cooldown: ").append(cooldown()).append(",");
        }
        if (metricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(metricAggregationType()).append(",");
        }
        if (stepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(stepAdjustments()).append(",");
        }
        if (estimatedInstanceWarmup() != null) {
            sb.append("EstimatedInstanceWarmup: ").append(estimatedInstanceWarmup()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.of(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.of(clazz.cast(policyType()));
        case "AdjustmentType":
            return Optional.of(clazz.cast(adjustmentType()));
        case "MinAdjustmentStep":
            return Optional.of(clazz.cast(minAdjustmentStep()));
        case "MinAdjustmentMagnitude":
            return Optional.of(clazz.cast(minAdjustmentMagnitude()));
        case "ScalingAdjustment":
            return Optional.of(clazz.cast(scalingAdjustment()));
        case "Cooldown":
            return Optional.of(clazz.cast(cooldown()));
        case "MetricAggregationType":
            return Optional.of(clazz.cast(metricAggregationType()));
        case "StepAdjustments":
            return Optional.of(clazz.cast(stepAdjustments()));
        case "EstimatedInstanceWarmup":
            return Optional.of(clazz.cast(estimatedInstanceWarmup()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutScalingPolicyRequest> {
        /**
         * <p>
         * The name or ARN of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or ARN of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>. If the policy type
         * is null, the value is treated as <code>SimpleScaling</code>.
         * </p>
         * 
         * @param policyType
         *        The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>. If the
         *        policy type is null, the value is treated as <code>SimpleScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The adjustment type. Valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         * <code>PercentChangeInCapacity</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
         * Scaling</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param adjustmentType
         *        The adjustment type. Valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         *        <code>PercentChangeInCapacity</code>.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-scale-based-on-demand.html">Dynamic
         *        Scaling</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);

        /**
         * <p>
         * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * </p>
         * 
         * @param minAdjustmentStep
         *        Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentStep(Integer minAdjustmentStep);

        /**
         * <p>
         * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
         * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
         * </p>
         * 
         * @param minAdjustmentMagnitude
         *        The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         *        <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of
         *        the Auto Scaling group by at least this many instances. Otherwise, the error is
         *        <code>ValidationError</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude);

        /**
         * <p>
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
         * capacity while a negative number removes from the current capacity.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>SimpleScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which to scale, based on the specified adjustment type. A positive value adds to the
         *        current capacity while a negative number removes from the current capacity.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>SimpleScaling</code> and not supported
         *        otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can
         * start. If this parameter is not specified, the default cooldown period for the group applies.
         * </p>
         * <p>
         * This parameter is not supported unless the policy type is <code>SimpleScaling</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param cooldown
         *        The amount of time, in seconds, after a scaling activity completes and before the next scaling
         *        activity can start. If this parameter is not specified, the default cooldown period for the group
         *        applies.</p>
         *        <p>
         *        This parameter is not supported unless the policy type is <code>SimpleScaling</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldown(Integer cooldown);

        /**
         * <p>
         * The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>,
         * and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.
         * </p>
         * <p>
         * This parameter is not supported if the policy type is <code>SimpleScaling</code>.
         * </p>
         * 
         * @param metricAggregationType
         *        The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>,
         *        <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated
         *        as <code>Average</code>.</p>
         *        <p>
         *        This parameter is not supported if the policy type is <code>SimpleScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAggregationType(String metricAggregationType);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(StepAdjustment... stepAdjustments);

        /**
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
         * default is to use the value specified for the default cooldown period for the group.
         * </p>
         * <p>
         * This parameter is not supported if the policy type is <code>SimpleScaling</code>.
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics. The default is to use the value specified for the default cooldown period for the group.</p>
         *        <p>
         *        This parameter is not supported if the policy type is <code>SimpleScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private String policyType;

        private String adjustmentType;

        private Integer minAdjustmentStep;

        private Integer minAdjustmentMagnitude;

        private Integer scalingAdjustment;

        private Integer cooldown;

        private String metricAggregationType;

        private List<StepAdjustment> stepAdjustments;

        private Integer estimatedInstanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            policyType(model.policyType);
            adjustmentType(model.adjustmentType);
            minAdjustmentStep(model.minAdjustmentStep);
            minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            scalingAdjustment(model.scalingAdjustment);
            cooldown(model.cooldown);
            metricAggregationType(model.metricAggregationType);
            stepAdjustments(model.stepAdjustments);
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            return stepAdjustments != null ? stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment... stepAdjustments) {
            stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }
    }
}
