/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach
 * threshold that you've defined for the alarm.
 * </p>
 * <p>
 * For the following examples, suppose that you have an alarm with a breach threshold of 50:
 * </p>
 * <ul>
 * <li>
 * <p>
 * If you want the adjustment to be triggered when the metric is greater than or equal to 50 and less than 60, specify a
 * lower bound of 0 and an upper bound of 10.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you want the adjustment to be triggered when the metric is greater than 40 and less than or equal to 50, specify a
 * lower bound of -10 and an upper bound of 0.
 * </p>
 * </li>
 * </ul>
 * <p>
 * There are a few rules for the step adjustments for your step policy:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The ranges of your step adjustments can't overlap or have a gap.
 * </p>
 * </li>
 * <li>
 * <p>
 * At most one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then
 * there must be a step adjustment with a null lower bound.
 * </p>
 * </li>
 * <li>
 * <p>
 * At most one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then
 * there must be a step adjustment with a null upper bound.
 * </p>
 * </li>
 * <li>
 * <p>
 * The upper and lower bound can't be null in the same step adjustment.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class StepAdjustment implements ToCopyableBuilder<StepAdjustment.Builder, StepAdjustment> {
    private final Double metricIntervalLowerBound;

    private final Double metricIntervalUpperBound;

    private final Integer scalingAdjustment;

    private StepAdjustment(BuilderImpl builder) {
        this.metricIntervalLowerBound = builder.metricIntervalLowerBound;
        this.metricIntervalUpperBound = builder.metricIntervalUpperBound;
        this.scalingAdjustment = builder.scalingAdjustment;
    }

    /**
     * <p>
     * The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is
     * above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the
     * threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus
     * the lower bound). A null value indicates negative infinity.
     * </p>
     * 
     * @return The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric
     *         value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or
     *         equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than
     *         the threshold plus the lower bound). A null value indicates negative infinity.
     */
    public Double metricIntervalLowerBound() {
        return metricIntervalLowerBound;
    }

    /**
     * <p>
     * The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is
     * above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the
     * upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper
     * bound). A null value indicates positive infinity.
     * </p>
     * <p>
     * The upper bound must be greater than the lower bound.
     * </p>
     * 
     * @return The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric
     *         value is above the breach threshold, the upper bound is exclusive (the metric must be less than the
     *         threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the
     *         threshold plus the upper bound). A null value indicates positive infinity.</p>
     *         <p>
     *         The upper bound must be greater than the lower bound.
     */
    public Double metricIntervalUpperBound() {
        return metricIntervalUpperBound;
    }

    /**
     * <p>
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
     * capacity while a negative number removes from the current capacity.
     * </p>
     * 
     * @return The amount by which to scale, based on the specified adjustment type. A positive value adds to the
     *         current capacity while a negative number removes from the current capacity.
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricIntervalLowerBound() == null) ? 0 : metricIntervalLowerBound().hashCode());
        hashCode = 31 * hashCode + ((metricIntervalUpperBound() == null) ? 0 : metricIntervalUpperBound().hashCode());
        hashCode = 31 * hashCode + ((scalingAdjustment() == null) ? 0 : scalingAdjustment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAdjustment)) {
            return false;
        }
        StepAdjustment other = (StepAdjustment) obj;
        if (other.metricIntervalLowerBound() == null ^ this.metricIntervalLowerBound() == null) {
            return false;
        }
        if (other.metricIntervalLowerBound() != null && !other.metricIntervalLowerBound().equals(this.metricIntervalLowerBound())) {
            return false;
        }
        if (other.metricIntervalUpperBound() == null ^ this.metricIntervalUpperBound() == null) {
            return false;
        }
        if (other.metricIntervalUpperBound() != null && !other.metricIntervalUpperBound().equals(this.metricIntervalUpperBound())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (metricIntervalLowerBound() != null) {
            sb.append("MetricIntervalLowerBound: ").append(metricIntervalLowerBound()).append(",");
        }
        if (metricIntervalUpperBound() != null) {
            sb.append("MetricIntervalUpperBound: ").append(metricIntervalUpperBound()).append(",");
        }
        if (scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(scalingAdjustment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricIntervalLowerBound":
            return Optional.of(clazz.cast(metricIntervalLowerBound()));
        case "MetricIntervalUpperBound":
            return Optional.of(clazz.cast(metricIntervalUpperBound()));
        case "ScalingAdjustment":
            return Optional.of(clazz.cast(scalingAdjustment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StepAdjustment> {
        /**
         * <p>
         * The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value
         * is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the
         * threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold
         * plus the lower bound). A null value indicates negative infinity.
         * </p>
         * 
         * @param metricIntervalLowerBound
         *        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the
         *        metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater
         *        than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be
         *        greater than the threshold plus the lower bound). A null value indicates negative infinity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricIntervalLowerBound(Double metricIntervalLowerBound);

        /**
         * <p>
         * The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value
         * is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus
         * the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the
         * upper bound). A null value indicates positive infinity.
         * </p>
         * <p>
         * The upper bound must be greater than the lower bound.
         * </p>
         * 
         * @param metricIntervalUpperBound
         *        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the
         *        metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than
         *        the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal
         *        to the threshold plus the upper bound). A null value indicates positive infinity.</p>
         *        <p>
         *        The upper bound must be greater than the lower bound.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricIntervalUpperBound(Double metricIntervalUpperBound);

        /**
         * <p>
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
         * capacity while a negative number removes from the current capacity.
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which to scale, based on the specified adjustment type. A positive value adds to the
         *        current capacity while a negative number removes from the current capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);
    }

    static final class BuilderImpl implements Builder {
        private Double metricIntervalLowerBound;

        private Double metricIntervalUpperBound;

        private Integer scalingAdjustment;

        private BuilderImpl() {
        }

        private BuilderImpl(StepAdjustment model) {
            metricIntervalLowerBound(model.metricIntervalLowerBound);
            metricIntervalUpperBound(model.metricIntervalUpperBound);
            scalingAdjustment(model.scalingAdjustment);
        }

        public final Double getMetricIntervalLowerBound() {
            return metricIntervalLowerBound;
        }

        @Override
        public final Builder metricIntervalLowerBound(Double metricIntervalLowerBound) {
            this.metricIntervalLowerBound = metricIntervalLowerBound;
            return this;
        }

        public final void setMetricIntervalLowerBound(Double metricIntervalLowerBound) {
            this.metricIntervalLowerBound = metricIntervalLowerBound;
        }

        public final Double getMetricIntervalUpperBound() {
            return metricIntervalUpperBound;
        }

        @Override
        public final Builder metricIntervalUpperBound(Double metricIntervalUpperBound) {
            this.metricIntervalUpperBound = metricIntervalUpperBound;
            return this;
        }

        public final void setMetricIntervalUpperBound(Double metricIntervalUpperBound) {
            this.metricIntervalUpperBound = metricIntervalUpperBound;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        public StepAdjustment build() {
            return new StepAdjustment(this);
        }
    }
}
