/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeLifecycleHooksRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeLifecycleHooksRequestMarshaller implements
        Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {

    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {

        if (describeLifecycleHooksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeLifecycleHooksRequest> request = new DefaultRequest<DescribeLifecycleHooksRequest>(
                describeLifecycleHooksRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeLifecycleHooksRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(describeLifecycleHooksRequest.autoScalingGroupName()));
        }

        java.util.List<String> lifecycleHookNamesList = describeLifecycleHooksRequest.lifecycleHookNames();

        if (lifecycleHookNamesList != null) {
            if (!lifecycleHookNamesList.isEmpty()) {
                int lifecycleHookNamesListIndex = 1;

                for (String lifecycleHookNamesListValue : lifecycleHookNamesList) {
                    if (lifecycleHookNamesListValue != null) {
                        request.addParameter("LifecycleHookNames.member." + lifecycleHookNamesListIndex,
                                StringUtils.fromString(lifecycleHookNamesListValue));
                    }
                    lifecycleHookNamesListIndex++;
                }
            } else {
                request.addParameter("LifecycleHookNames", "");
            }
        }

        return request;
    }

}
