/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeTagsRequestMarshaller implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {

    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {

        if (describeTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeTagsRequest> request = new DefaultRequest<DescribeTagsRequest>(describeTagsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> filtersList = describeTagsRequest.filters();

        if (filtersList != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;

                for (Filter filtersListValue : filtersList) {

                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Name",
                                StringUtils.fromString(filtersListValue.name()));
                    }

                    java.util.List<String> valuesList = filtersListValue.values();

                    if (valuesList != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;

                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.member." + filtersListIndex + ".Values.member."
                                            + valuesListIndex, StringUtils.fromString(valuesListValue));
                                }
                                valuesListIndex++;
                            }
                        } else {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values", "");
                        }
                    }
                    filtersListIndex++;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }

        if (describeTagsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeTagsRequest.nextToken()));
        }

        if (describeTagsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeTagsRequest.maxRecords()));
        }

        return request;
    }

}
