/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentType;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAdjustmentTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    public List<AdjustmentType> adjustmentTypes() {
        return this.adjustmentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.adjustmentTypes() == null ? 0 : this.adjustmentTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse)((Object)obj);
        if (other.adjustmentTypes() == null ^ this.adjustmentTypes() == null) {
            return false;
        }
        return other.adjustmentTypes() == null || other.adjustmentTypes().equals(this.adjustmentTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.adjustmentTypes() != null) {
            sb.append("AdjustmentTypes: ").append(this.adjustmentTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentTypes": {
                return Optional.of(clazz.cast(this.adjustmentTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AdjustmentType> adjustmentTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            this.adjustmentTypes(model.adjustmentTypes);
        }

        public final Collection<AdjustmentType.Builder> getAdjustmentTypes() {
            return this.adjustmentTypes != null ? (Collection)this.adjustmentTypes.stream().map(AdjustmentType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType ... adjustmentTypes) {
            this.adjustmentTypes(Arrays.asList(adjustmentTypes));
            return this;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType.BuilderImpl> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copyFromBuilder(adjustmentTypes);
        }

        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        public Builder adjustmentTypes(Collection<AdjustmentType> var1);

        public Builder adjustmentTypes(AdjustmentType ... var1);
    }
}

