/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledActionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;
    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.scheduledUpdateGroupActions() == null ? 0 : this.scheduledUpdateGroupActions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        if (other.scheduledUpdateGroupActions() == null ^ this.scheduledUpdateGroupActions() == null) {
            return false;
        }
        if (other.scheduledUpdateGroupActions() != null && !other.scheduledUpdateGroupActions().equals(this.scheduledUpdateGroupActions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.scheduledUpdateGroupActions() != null) {
            sb.append("ScheduledUpdateGroupActions: ").append(this.scheduledUpdateGroupActions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledUpdateGroupActions": {
                return Optional.of(clazz.cast(this.scheduledUpdateGroupActions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            this.scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction.Builder> getScheduledUpdateGroupActions() {
            return this.scheduledUpdateGroupActions != null ? (Collection)this.scheduledUpdateGroupActions.stream().map(ScheduledUpdateGroupAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> var1);

        public Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... var1);

        public Builder nextToken(String var1);
    }
}

