/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.autoscaling.model.ClassicLinkVPCSecurityGroupsCopier;
import software.amazon.awssdk.services.autoscaling.model.InstanceMonitoring;
import software.amazon.awssdk.services.autoscaling.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchConfiguration
implements ToCopyableBuilder<Builder, LaunchConfiguration> {
    private final String launchConfigurationName;
    private final String launchConfigurationARN;
    private final String imageId;
    private final String keyName;
    private final List<String> securityGroups;
    private final String classicLinkVPCId;
    private final List<String> classicLinkVPCSecurityGroups;
    private final String userData;
    private final String instanceType;
    private final String kernelId;
    private final String ramdiskId;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final InstanceMonitoring instanceMonitoring;
    private final String spotPrice;
    private final String iamInstanceProfile;
    private final Instant createdTime;
    private final Boolean ebsOptimized;
    private final Boolean associatePublicIpAddress;
    private final String placementTenancy;

    private LaunchConfiguration(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchConfigurationARN = builder.launchConfigurationARN;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public String launchConfigurationARN() {
        return this.launchConfigurationARN;
    }

    public String imageId() {
        return this.imageId;
    }

    public String keyName() {
        return this.keyName;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String classicLinkVPCId() {
        return this.classicLinkVPCId;
    }

    public List<String> classicLinkVPCSecurityGroups() {
        return this.classicLinkVPCSecurityGroups;
    }

    public String userData() {
        return this.userData;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public InstanceMonitoring instanceMonitoring() {
        return this.instanceMonitoring;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public String placementTenancy() {
        return this.placementTenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.launchConfigurationName() == null ? 0 : this.launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.launchConfigurationARN() == null ? 0 : this.launchConfigurationARN().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.classicLinkVPCId() == null ? 0 : this.classicLinkVPCId().hashCode());
        hashCode = 31 * hashCode + (this.classicLinkVPCSecurityGroups() == null ? 0 : this.classicLinkVPCSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.instanceMonitoring() == null ? 0 : this.instanceMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.associatePublicIpAddress() == null ? 0 : this.associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.placementTenancy() == null ? 0 : this.placementTenancy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.launchConfigurationARN() == null ^ this.launchConfigurationARN() == null) {
            return false;
        }
        if (other.launchConfigurationARN() != null && !other.launchConfigurationARN().equals(this.launchConfigurationARN())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.classicLinkVPCId() == null ^ this.classicLinkVPCId() == null) {
            return false;
        }
        if (other.classicLinkVPCId() != null && !other.classicLinkVPCId().equals(this.classicLinkVPCId())) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() == null ^ this.classicLinkVPCSecurityGroups() == null) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() != null && !other.classicLinkVPCSecurityGroups().equals(this.classicLinkVPCSecurityGroups())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.instanceMonitoring() == null ^ this.instanceMonitoring() == null) {
            return false;
        }
        if (other.instanceMonitoring() != null && !other.instanceMonitoring().equals(this.instanceMonitoring())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.placementTenancy() == null ^ this.placementTenancy() == null) {
            return false;
        }
        return other.placementTenancy() == null || other.placementTenancy().equals(this.placementTenancy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.launchConfigurationName()).append(",");
        }
        if (this.launchConfigurationARN() != null) {
            sb.append("LaunchConfigurationARN: ").append(this.launchConfigurationARN()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.classicLinkVPCId() != null) {
            sb.append("ClassicLinkVPCId: ").append(this.classicLinkVPCId()).append(",");
        }
        if (this.classicLinkVPCSecurityGroups() != null) {
            sb.append("ClassicLinkVPCSecurityGroups: ").append(this.classicLinkVPCSecurityGroups()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.instanceMonitoring() != null) {
            sb.append("InstanceMonitoring: ").append(this.instanceMonitoring()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.associatePublicIpAddress()).append(",");
        }
        if (this.placementTenancy() != null) {
            sb.append("PlacementTenancy: ").append(this.placementTenancy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationName": {
                return Optional.of(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchConfigurationARN": {
                return Optional.of(clazz.cast(this.launchConfigurationARN()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "ClassicLinkVPCId": {
                return Optional.of(clazz.cast(this.classicLinkVPCId()));
            }
            case "ClassicLinkVPCSecurityGroups": {
                return Optional.of(clazz.cast(this.classicLinkVPCSecurityGroups()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "InstanceMonitoring": {
                return Optional.of(clazz.cast(this.instanceMonitoring()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "AssociatePublicIpAddress": {
                return Optional.of(clazz.cast(this.associatePublicIpAddress()));
            }
            case "PlacementTenancy": {
                return Optional.of(clazz.cast(this.placementTenancy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String launchConfigurationName;
        private String launchConfigurationARN;
        private String imageId;
        private String keyName;
        private List<String> securityGroups;
        private String classicLinkVPCId;
        private List<String> classicLinkVPCSecurityGroups;
        private String userData;
        private String instanceType;
        private String kernelId;
        private String ramdiskId;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private InstanceMonitoring instanceMonitoring;
        private String spotPrice;
        private String iamInstanceProfile;
        private Instant createdTime;
        private Boolean ebsOptimized;
        private Boolean associatePublicIpAddress;
        private String placementTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfiguration model) {
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchConfigurationARN(model.launchConfigurationARN);
            this.imageId(model.imageId);
            this.keyName(model.keyName);
            this.securityGroups(model.securityGroups);
            this.classicLinkVPCId(model.classicLinkVPCId);
            this.classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            this.userData(model.userData);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.instanceMonitoring(model.instanceMonitoring);
            this.spotPrice(model.spotPrice);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.createdTime(model.createdTime);
            this.ebsOptimized(model.ebsOptimized);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.placementTenancy(model.placementTenancy);
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getLaunchConfigurationARN() {
            return this.launchConfigurationARN;
        }

        @Override
        public final Builder launchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
            return this;
        }

        public final void setLaunchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return this.classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return this.classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String ... classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return this.instanceMonitoring != null ? this.instanceMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return this.placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        public LaunchConfiguration build() {
            return new LaunchConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchConfiguration> {
        public Builder launchConfigurationName(String var1);

        public Builder launchConfigurationARN(String var1);

        public Builder imageId(String var1);

        public Builder keyName(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder classicLinkVPCId(String var1);

        public Builder classicLinkVPCSecurityGroups(Collection<String> var1);

        public Builder classicLinkVPCSecurityGroups(String ... var1);

        public Builder userData(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder ramdiskId(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder instanceMonitoring(InstanceMonitoring var1);

        public Builder spotPrice(String var1);

        public Builder iamInstanceProfile(String var1);

        public Builder createdTime(Instant var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder placementTenancy(String var1);
    }
}

