/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        List<StepAdjustment> stepAdjustmentsList;
        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScalingPolicyRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putScalingPolicyRequest.autoScalingGroupName()));
        }
        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)putScalingPolicyRequest.policyName()));
        }
        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString((String)putScalingPolicyRequest.policyType()));
        }
        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString((String)putScalingPolicyRequest.adjustmentType()));
        }
        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentStep()));
        }
        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude", StringUtils.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentMagnitude()));
        }
        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger((Integer)putScalingPolicyRequest.scalingAdjustment()));
        }
        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger((Integer)putScalingPolicyRequest.cooldown()));
        }
        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString((String)putScalingPolicyRequest.metricAggregationType()));
        }
        if ((stepAdjustmentsList = putScalingPolicyRequest.stepAdjustments()) != null) {
            if (!stepAdjustmentsList.isEmpty()) {
                int stepAdjustmentsListIndex = 1;
                for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {
                    if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.metricIntervalLowerBound()));
                    }
                    if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound", StringUtils.fromDouble((Double)stepAdjustmentsListValue.metricIntervalUpperBound()));
                    }
                    if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment", StringUtils.fromInteger((Integer)stepAdjustmentsListValue.scalingAdjustment()));
                    }
                    ++stepAdjustmentsListIndex;
                }
            } else {
                request.addParameter("StepAdjustments", "");
            }
        }
        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup", StringUtils.fromInteger((Integer)putScalingPolicyRequest.estimatedInstanceWarmup()));
        }
        return request;
    }
}

