/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a policy adjustment type.
 * </p>
 * <p>
 * For more information, see <a
 * href="http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html">Dynamic Scaling</a>
 * in the <i>Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AdjustmentType implements ToCopyableBuilder<AdjustmentType.Builder, AdjustmentType> {
    private final String adjustmentType;

    private AdjustmentType(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
    }

    /**
     * <p>
     * The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     * <code>PercentChangeInCapacity</code>.
     * </p>
     * 
     * @return The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
     *         <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdjustmentType)) {
            return false;
        }
        AdjustmentType other = (AdjustmentType) obj;
        return Objects.equals(adjustmentType(), other.adjustmentType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(adjustmentType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdjustmentType":
            return Optional.of(clazz.cast(adjustmentType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AdjustmentType> {
        /**
         * <p>
         * The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>,
         * and <code>PercentChangeInCapacity</code>.
         * </p>
         * 
         * @param adjustmentType
         *        The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
         *        <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);
    }

    static final class BuilderImpl implements Builder {
        private String adjustmentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AdjustmentType model) {
            adjustmentType(model.adjustmentType);
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        @Override
        public AdjustmentType build() {
            return new AdjustmentType(this);
        }
    }
}
