/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EnterStandbyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<EnterStandbyResponse.Builder, EnterStandbyResponse> {
    private final List<Activity> activities;

    private EnterStandbyResponse(BuilderImpl builder) {
        this.activities = builder.activities;
    }

    /**
     * <p>
     * The activities related to moving instances into <code>Standby</code> mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The activities related to moving instances into <code>Standby</code> mode.
     */
    public List<Activity> activities() {
        return activities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnterStandbyResponse)) {
            return false;
        }
        EnterStandbyResponse other = (EnterStandbyResponse) obj;
        return Objects.equals(activities(), other.activities());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (activities() != null) {
            sb.append("Activities: ").append(activities()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activities":
            return Optional.of(clazz.cast(activities()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, EnterStandbyResponse> {
        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);
    }

    static final class BuilderImpl implements Builder {
        private List<Activity> activities;

        private BuilderImpl() {
        }

        private BuilderImpl(EnterStandbyResponse model) {
            activities(model.activities);
        }

        public final Collection<Activity.Builder> getActivities() {
            return activities != null ? activities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity.BuilderImpl> activities) {
            this.activities = ActivitiesCopier.copyFromBuilder(activities);
        }

        @Override
        public EnterStandbyResponse build() {
            return new EnterStandbyResponse(this);
        }
    }
}
