/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NotificationConfiguration implements ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private final String autoScalingGroupName;

    private final String topicARN;

    private final String notificationType;

    private NotificationConfiguration(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationType = builder.notificationType;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     */
    public String topicARN() {
        return topicARN;
    }

    /**
     * <p>
     * One of the following event notification types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>autoscaling:TEST_NOTIFICATION</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following event notification types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>autoscaling:TEST_NOTIFICATION</code>
     *         </p>
     *         </li>
     */
    public String notificationType() {
        return notificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(topicARN(), other.topicARN()) && Objects.equals(notificationType(), other.notificationType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (topicARN() != null) {
            sb.append("TopicARN: ").append(topicARN()).append(",");
        }
        if (notificationType() != null) {
            sb.append("NotificationType: ").append(notificationType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "TopicARN":
            return Optional.of(clazz.cast(topicARN()));
        case "NotificationType":
            return Optional.of(clazz.cast(notificationType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * One of the following event notification types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>autoscaling:TEST_NOTIFICATION</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param notificationType
         *        One of the following event notification types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>autoscaling:TEST_NOTIFICATION</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationType(String notificationType);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            autoScalingGroupName(model.autoScalingGroupName);
            topicARN(model.topicARN);
            notificationType(model.notificationType);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }
    }
}
