/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a process type.
 * </p>
 * <p>
 * For more information, see <a
 * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html#process-types">Auto
 * Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProcessType implements ToCopyableBuilder<ProcessType.Builder, ProcessType> {
    private final String processName;

    private ProcessType(BuilderImpl builder) {
        this.processName = builder.processName;
    }

    /**
     * <p>
     * One of the following processes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Launch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AddToLoadBalancer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AlarmNotification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AZRebalance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HealthCheck</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceUnhealthy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActions</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following processes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Launch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AddToLoadBalancer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AlarmNotification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AZRebalance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HealthCheck</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceUnhealthy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActions</code>
     *         </p>
     *         </li>
     */
    public String processName() {
        return processName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessType)) {
            return false;
        }
        ProcessType other = (ProcessType) obj;
        return Objects.equals(processName(), other.processName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (processName() != null) {
            sb.append("ProcessName: ").append(processName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessName":
            return Optional.of(clazz.cast(processName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ProcessType> {
        /**
         * <p>
         * One of the following processes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param processName
         *        One of the following processes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processName(String processName);
    }

    static final class BuilderImpl implements Builder {
        private String processName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessType model) {
            processName(model.processName);
        }

        public final String getProcessName() {
            return processName;
        }

        @Override
        public final Builder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public final void setProcessName(String processName) {
            this.processName = processName;
        }

        @Override
        public ProcessType build() {
            return new ProcessType(this);
        }
    }
}
