/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutNotificationConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutNotificationConfigurationRequest.Builder, PutNotificationConfigurationRequest> {
    private final String autoScalingGroupName;

    private final String topicARN;

    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     */
    public String topicARN() {
        return topicARN;
    }

    /**
     * <p>
     * The type of event that will cause the notification to be sent. For details about notification types supported by
     * Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The type of event that will cause the notification to be sent. For details about notification types
     *         supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
     */
    public List<String> notificationTypes() {
        return notificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(topicARN(), other.topicARN()) && Objects.equals(notificationTypes(), other.notificationTypes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (topicARN() != null) {
            sb.append("TopicARN: ").append(topicARN()).append(",");
        }
        if (notificationTypes() != null) {
            sb.append("NotificationTypes: ").append(notificationTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "TopicARN":
            return Optional.of(clazz.cast(topicARN()));
        case "NotificationTypes":
            return Optional.of(clazz.cast(notificationTypes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * The type of event that will cause the notification to be sent. For details about notification types supported
         * by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that will cause the notification to be sent. For details about notification types
         *        supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(Collection<String> notificationTypes);

        /**
         * <p>
         * The type of event that will cause the notification to be sent. For details about notification types supported
         * by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that will cause the notification to be sent. For details about notification types
         *        supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(String... notificationTypes);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private List<String> notificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            topicARN(model.topicARN);
            notificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final Collection<String> getNotificationTypes() {
            return notificationTypes;
        }

        @Override
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTypes(String... notificationTypes) {
            notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        @Override
        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }
    }
}
