/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PutScalingPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScalingPolicyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutScalingPolicyResponse.Builder, PutScalingPolicyResponse> {
    private final String policyARN;

    private final List<Alarm> alarms;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.
     */
    public String policyARN() {
        return policyARN;
    }

    /**
     * <p>
     * The CloudWatch alarms created for the target tracking policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The CloudWatch alarms created for the target tracking policy.
     */
    public List<Alarm> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(alarms());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse) obj;
        return Objects.equals(policyARN(), other.policyARN()) && Objects.equals(alarms(), other.alarms());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyARN() != null) {
            sb.append("PolicyARN: ").append(policyARN()).append(",");
        }
        if (alarms() != null) {
            sb.append("Alarms: ").append(alarms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyARN":
            return Optional.of(clazz.cast(policyARN()));
        case "Alarms":
            return Optional.of(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutScalingPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyARN
         *        The Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyARN(String policyARN);

        /**
         * <p>
         * The CloudWatch alarms created for the target tracking policy.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms created for the target tracking policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * The CloudWatch alarms created for the target tracking policy.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms created for the target tracking policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);
    }

    static final class BuilderImpl implements Builder {
        private String policyARN;

        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            policyARN(model.policyARN);
            alarms(model.alarms);
        }

        public final String getPolicyARN() {
            return policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return alarms != null ? alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        @Override
        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }
    }
}
