/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LifecycleHookSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LifecycleHookSpecificationUnmarshaller implements Unmarshaller<LifecycleHookSpecification, StaxUnmarshallerContext> {

    public LifecycleHookSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleHookSpecification.Builder lifecycleHookSpecification = LifecycleHookSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("LifecycleHookName", targetDepth)) {
                    lifecycleHookSpecification.lifecycleHookName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LifecycleTransition", targetDepth)) {
                    lifecycleHookSpecification.lifecycleTransition(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NotificationMetadata", targetDepth)) {
                    lifecycleHookSpecification.notificationMetadata(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HeartbeatTimeout", targetDepth)) {
                    lifecycleHookSpecification.heartbeatTimeout(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DefaultResult", targetDepth)) {
                    lifecycleHookSpecification.defaultResult(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NotificationTargetARN", targetDepth)) {
                    lifecycleHookSpecification.notificationTargetARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RoleARN", targetDepth)) {
                    lifecycleHookSpecification.roleARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return lifecycleHookSpecification.build();
    }

    private static final LifecycleHookSpecificationUnmarshaller INSTANCE = new LifecycleHookSpecificationUnmarshaller();

    public static LifecycleHookSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
