/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLifecycleHookRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteLifecycleHookRequest> {
    private final String lifecycleHookName;
    private final String autoScalingGroupName;

    private DeleteLifecycleHookRequest(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLifecycleHookRequest)) {
            return false;
        }
        DeleteLifecycleHookRequest other = (DeleteLifecycleHookRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lifecycleHookName() != null) {
            sb.append("LifecycleHookName: ").append(this.lifecycleHookName()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.of(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLifecycleHookRequest model) {
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public DeleteLifecycleHookRequest build() {
            return new DeleteLifecycleHookRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteLifecycleHookRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);
    }
}

