/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLifecycleHookTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
    private final List<String> lifecycleHookTypes;

    private DescribeLifecycleHookTypesResponse(BuilderImpl builder) {
        this.lifecycleHookTypes = builder.lifecycleHookTypes;
    }

    public List<String> lifecycleHookTypes() {
        return this.lifecycleHookTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHookTypesResponse)) {
            return false;
        }
        DescribeLifecycleHookTypesResponse other = (DescribeLifecycleHookTypesResponse)((Object)obj);
        return Objects.equals(this.lifecycleHookTypes(), other.lifecycleHookTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lifecycleHookTypes() != null) {
            sb.append("LifecycleHookTypes: ").append(this.lifecycleHookTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookTypes": {
                return Optional.of(clazz.cast(this.lifecycleHookTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> lifecycleHookTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHookTypesResponse model) {
            this.lifecycleHookTypes(model.lifecycleHookTypes);
        }

        public final Collection<String> getLifecycleHookTypes() {
            return this.lifecycleHookTypes;
        }

        @Override
        public final Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookTypes(String ... lifecycleHookTypes) {
            this.lifecycleHookTypes(Arrays.asList(lifecycleHookTypes));
            return this;
        }

        public final void setLifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
        }

        public DescribeLifecycleHookTypesResponse build() {
            return new DescribeLifecycleHookTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
        public Builder lifecycleHookTypes(Collection<String> var1);

        public Builder lifecycleHookTypes(String ... var1);
    }
}

