/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotificationConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
    private final List<NotificationConfiguration> notificationConfigurations;
    private final String nextToken;

    private DescribeNotificationConfigurationsResponse(BuilderImpl builder) {
        this.notificationConfigurations = builder.notificationConfigurations;
        this.nextToken = builder.nextToken;
    }

    public List<NotificationConfiguration> notificationConfigurations() {
        return this.notificationConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsResponse)) {
            return false;
        }
        DescribeNotificationConfigurationsResponse other = (DescribeNotificationConfigurationsResponse)((Object)obj);
        return Objects.equals(this.notificationConfigurations(), other.notificationConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.notificationConfigurations() != null) {
            sb.append("NotificationConfigurations: ").append(this.notificationConfigurations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationConfigurations": {
                return Optional.of(clazz.cast(this.notificationConfigurations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<NotificationConfiguration> notificationConfigurations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsResponse model) {
            this.notificationConfigurations(model.notificationConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<NotificationConfiguration.Builder> getNotificationConfigurations() {
            return this.notificationConfigurations != null ? (Collection)this.notificationConfigurations.stream().map(NotificationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfiguration ... notificationConfigurations) {
            this.notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        public final void setNotificationConfigurations(Collection<NotificationConfiguration.BuilderImpl> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copyFromBuilder(notificationConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNotificationConfigurationsResponse build() {
            return new DescribeNotificationConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
        public Builder notificationConfigurations(Collection<NotificationConfiguration> var1);

        public Builder notificationConfigurations(NotificationConfiguration ... var1);

        public Builder nextToken(String var1);
    }
}

