/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutLifecycleHookRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutLifecycleHookRequest> {
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleTransition;
    private final String roleARN;
    private final String notificationTargetARN;
    private final String notificationMetadata;
    private final Integer heartbeatTimeout;
    private final String defaultResult;

    private PutLifecycleHookRequest(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.roleARN = builder.roleARN;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String lifecycleTransition() {
        return this.lifecycleTransition;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String notificationTargetARN() {
        return this.notificationTargetARN;
    }

    public String notificationMetadata() {
        return this.notificationMetadata;
    }

    public Integer heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public String defaultResult() {
        return this.defaultResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleHookRequest)) {
            return false;
        }
        PutLifecycleHookRequest other = (PutLifecycleHookRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleTransition(), other.lifecycleTransition()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.notificationTargetARN(), other.notificationTargetARN()) && Objects.equals(this.notificationMetadata(), other.notificationMetadata()) && Objects.equals(this.heartbeatTimeout(), other.heartbeatTimeout()) && Objects.equals(this.defaultResult(), other.defaultResult());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lifecycleHookName() != null) {
            sb.append("LifecycleHookName: ").append(this.lifecycleHookName()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.lifecycleTransition() != null) {
            sb.append("LifecycleTransition: ").append(this.lifecycleTransition()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.notificationTargetARN() != null) {
            sb.append("NotificationTargetARN: ").append(this.notificationTargetARN()).append(",");
        }
        if (this.notificationMetadata() != null) {
            sb.append("NotificationMetadata: ").append(this.notificationMetadata()).append(",");
        }
        if (this.heartbeatTimeout() != null) {
            sb.append("HeartbeatTimeout: ").append(this.heartbeatTimeout()).append(",");
        }
        if (this.defaultResult() != null) {
            sb.append("DefaultResult: ").append(this.defaultResult()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.of(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleTransition": {
                return Optional.of(clazz.cast(this.lifecycleTransition()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "NotificationTargetARN": {
                return Optional.of(clazz.cast(this.notificationTargetARN()));
            }
            case "NotificationMetadata": {
                return Optional.of(clazz.cast(this.notificationMetadata()));
            }
            case "HeartbeatTimeout": {
                return Optional.of(clazz.cast(this.heartbeatTimeout()));
            }
            case "DefaultResult": {
                return Optional.of(clazz.cast(this.defaultResult()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleTransition;
        private String roleARN;
        private String notificationTargetARN;
        private String notificationMetadata;
        private Integer heartbeatTimeout;
        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleHookRequest model) {
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleTransition(model.lifecycleTransition);
            this.roleARN(model.roleARN);
            this.notificationTargetARN(model.notificationTargetARN);
            this.notificationMetadata(model.notificationMetadata);
            this.heartbeatTimeout(model.heartbeatTimeout);
            this.defaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        public final String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        public final Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        public final String getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        public PutLifecycleHookRequest build() {
            return new PutLifecycleHookRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutLifecycleHookRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleTransition(String var1);

        public Builder roleARN(String var1);

        public Builder notificationTargetARN(String var1);

        public Builder notificationMetadata(String var1);

        public Builder heartbeatTimeout(Integer var1);

        public Builder defaultResult(String var1);
    }
}

