/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;

public class AttachInstancesRequestMarshaller
implements Marshaller<Request<AttachInstancesRequest>, AttachInstancesRequest> {
    public Request<AttachInstancesRequest> marshall(AttachInstancesRequest attachInstancesRequest) {
        if (attachInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> instanceIdsList = attachInstancesRequest.instanceIds();
        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }
        if (attachInstancesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)attachInstancesRequest.autoScalingGroupName()));
        }
        return request;
    }
}

