/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;

public class SetInstanceHealthRequestMarshaller
implements Marshaller<Request<SetInstanceHealthRequest>, SetInstanceHealthRequest> {
    public Request<SetInstanceHealthRequest> marshall(SetInstanceHealthRequest setInstanceHealthRequest) {
        if (setInstanceHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setInstanceHealthRequest, "AutoScalingClient");
        request.addParameter("Action", "SetInstanceHealth");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setInstanceHealthRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)setInstanceHealthRequest.instanceId()));
        }
        if (setInstanceHealthRequest.healthStatus() != null) {
            request.addParameter("HealthStatus", StringUtils.fromString((String)setInstanceHealthRequest.healthStatus()));
        }
        if (setInstanceHealthRequest.shouldRespectGracePeriod() != null) {
            request.addParameter("ShouldRespectGracePeriod", StringUtils.fromBoolean((Boolean)setInstanceHealthRequest.shouldRespectGracePeriod()));
        }
        return request;
    }
}

