/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Alarm implements ToCopyableBuilder<Alarm.Builder, Alarm> {
    private final String alarmName;

    private final String alarmARN;

    private Alarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmARN = builder.alarmARN;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alarm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alarm.
     */
    public String alarmARN() {
        return alarmARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(alarmARN(), other.alarmARN());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (alarmARN() != null) {
            sb.append("AlarmARN: ").append(alarmARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.of(clazz.cast(alarmName()));
        case "AlarmARN":
            return Optional.of(clazz.cast(alarmARN()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Alarm> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alarm.
         * </p>
         * 
         * @param alarmARN
         *        The Amazon Resource Name (ARN) of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmARN(String alarmARN);
    }

    static final class BuilderImpl implements Builder {
        private String alarmName;

        private String alarmARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            alarmName(model.alarmName);
            alarmARN(model.alarmARN);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmARN() {
            return alarmARN;
        }

        @Override
        public final Builder alarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
            return this;
        }

        public final void setAlarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
        }

        @Override
        public Alarm build() {
            return new Alarm(this);
        }
    }
}
