/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CreateAutoScalingGroupRequest.Builder, CreateAutoScalingGroupRequest> {
    private final String autoScalingGroupName;

    private final String launchConfigurationName;

    private final String instanceId;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final List<String> loadBalancerNames;

    private final List<String> targetGroupARNs;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private final List<LifecycleHookSpecification> lifecycleHookSpecificationList;

    private final List<Tag> tags;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the group. This name must be unique within the scope of your AWS account.
     * </p>
     * 
     * @return The name of the group. This name must be unique within the scope of your AWS account.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the launch configuration. Alternatively, specify an EC2 instance instead of a launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration. Alternatively, specify an EC2 instance instead of a launch
     *         configuration.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The ID of the instance used to create a launch configuration for the group. Alternatively, specify a launch
     * configuration instead of an EC2 instance.
     * </p>
     * <p>
     * When you specify an ID of an instance, Auto Scaling creates a new launch configuration and associates it with the
     * group. This launch configuration derives its attributes from the specified instance, with the exception of the
     * block device mapping.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Create an Auto
     * Scaling Group Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance used to create a launch configuration for the group. Alternatively, specify a
     *         launch configuration instead of an EC2 instance.</p>
     *         <p>
     *         When you specify an ID of an instance, Auto Scaling creates a new launch configuration and associates it
     *         with the group. This launch configuration derives its attributes from the specified instance, with the
     *         exception of the block device mapping.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Create an
     *         Auto Scaling Group Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * 
     * @return The maximum size of the group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the group. This number must be greater than or equal to the
     * minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a
     * desired capacity, the default is the minimum size of the group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the group. This number must be greater than or
     *         equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do
     *         not specify a desired capacity, the default is the minimum size of the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The
     * default is 300.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before another scaling activity can
     *         start. The default is 300.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * <p>
     * One or more Availability Zones for the group. This parameter is optional if you specify one or more subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Availability Zones for the group. This parameter is optional if you specify one or more
     *         subnets.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * One or more Classic Load Balancers. To specify an Application Load Balancer, use <code>TargetGroupARNs</code>
     * instead.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a Load
     * Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Classic Load Balancers. To specify an Application Load Balancer, use
     *         <code>TargetGroupARNs</code> instead.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a Load
     *         Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     */
    public List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the target groups.
     */
    public List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    /**
     * <p>
     * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
     * </p>
     * <p>
     * By default, health checks use Amazon EC2 instance status checks to determine the health of an instance. For more
     * information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health
     * Checks</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.</p>
     *         <p>
     *         By default, health checks use Amazon EC2 instance status checks to determine the health of an instance.
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
     *         <i>Auto Scaling User Guide</i>.
     */
    public String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that
     * has come into service. During this time, any health check failures for the instance are ignored. The default is
     * 0.
     * </p>
     * <p>
     * This parameter is required if you are adding an <code>ELB</code> health check.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto
     * Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
     *         instance that has come into service. During this time, any health check failures for the instance are
     *         ignored. The default is 0.</p>
     *         <p>
     *         This parameter is required if you are adding an <code>ELB</code> health check.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
     *         <i>Auto Scaling User Guide</i>.
     */
    public Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The name of the placement group into which you'll launch your instances, if any. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
     *         Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * A comma-separated list of subnet identifiers for your virtual private cloud (VPC).
     * </p>
     * <p>
     * If you specify subnets and Availability Zones with this call, ensure that the subnets' Availability Zones match
     * the Availability Zones specified.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return A comma-separated list of subnet identifiers for your virtual private cloud (VPC).</p>
     *         <p>
     *         If you specify subnets and Availability Zones with this call, ensure that the subnets' Availability Zones
     *         match the Availability Zones specified.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * <p>
     * One or more termination policies used to select the instance to terminate. These policies are executed in the
     * order that they are listed.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
     * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more termination policies used to select the instance to terminate. These policies are executed in
     *         the order that they are listed.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling
     *         Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
     */
    public List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
     *         in.
     */
    public Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * One or more lifecycle hooks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more lifecycle hooks.
     */
    public List<LifecycleHookSpecification> lifecycleHookSpecificationList() {
        return lifecycleHookSpecificationList;
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling
     * Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto
     *         Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerNames());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupARNs());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(terminationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookSpecificationList());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(defaultCooldown(), other.defaultCooldown())
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && Objects.equals(targetGroupARNs(), other.targetGroupARNs())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(vpcZoneIdentifier(), other.vpcZoneIdentifier())
                && Objects.equals(terminationPolicies(), other.terminationPolicies())
                && Objects.equals(newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn())
                && Objects.equals(lifecycleHookSpecificationList(), other.lifecycleHookSpecificationList())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (minSize() != null) {
            sb.append("MinSize: ").append(minSize()).append(",");
        }
        if (maxSize() != null) {
            sb.append("MaxSize: ").append(maxSize()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        if (defaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(defaultCooldown()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(loadBalancerNames()).append(",");
        }
        if (targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(targetGroupARNs()).append(",");
        }
        if (healthCheckType() != null) {
            sb.append("HealthCheckType: ").append(healthCheckType()).append(",");
        }
        if (healthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(healthCheckGracePeriod()).append(",");
        }
        if (placementGroup() != null) {
            sb.append("PlacementGroup: ").append(placementGroup()).append(",");
        }
        if (vpcZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(vpcZoneIdentifier()).append(",");
        }
        if (terminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(terminationPolicies()).append(",");
        }
        if (newInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(newInstancesProtectedFromScaleIn()).append(",");
        }
        if (lifecycleHookSpecificationList() != null) {
            sb.append("LifecycleHookSpecificationList: ").append(lifecycleHookSpecificationList()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "LaunchConfigurationName":
            return Optional.of(clazz.cast(launchConfigurationName()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "MinSize":
            return Optional.of(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.of(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.of(clazz.cast(desiredCapacity()));
        case "DefaultCooldown":
            return Optional.of(clazz.cast(defaultCooldown()));
        case "AvailabilityZones":
            return Optional.of(clazz.cast(availabilityZones()));
        case "LoadBalancerNames":
            return Optional.of(clazz.cast(loadBalancerNames()));
        case "TargetGroupARNs":
            return Optional.of(clazz.cast(targetGroupARNs()));
        case "HealthCheckType":
            return Optional.of(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.of(clazz.cast(healthCheckGracePeriod()));
        case "PlacementGroup":
            return Optional.of(clazz.cast(placementGroup()));
        case "VPCZoneIdentifier":
            return Optional.of(clazz.cast(vpcZoneIdentifier()));
        case "TerminationPolicies":
            return Optional.of(clazz.cast(terminationPolicies()));
        case "NewInstancesProtectedFromScaleIn":
            return Optional.of(clazz.cast(newInstancesProtectedFromScaleIn()));
        case "LifecycleHookSpecificationList":
            return Optional.of(clazz.cast(lifecycleHookSpecificationList()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the group. This name must be unique within the scope of your AWS account.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group. This name must be unique within the scope of your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the launch configuration. Alternatively, specify an EC2 instance instead of a launch
         * configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration. Alternatively, specify an EC2 instance instead of a launch
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The ID of the instance used to create a launch configuration for the group. Alternatively, specify a launch
         * configuration instead of an EC2 instance.
         * </p>
         * <p>
         * When you specify an ID of an instance, Auto Scaling creates a new launch configuration and associates it with
         * the group. This launch configuration derives its attributes from the specified instance, with the exception
         * of the block device mapping.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Create an Auto
         * Scaling Group Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance used to create a launch configuration for the group. Alternatively, specify a
         *        launch configuration instead of an EC2 instance.</p>
         *        <p>
         *        When you specify an ID of an instance, Auto Scaling creates a new launch configuration and associates
         *        it with the group. This launch configuration derives its attributes from the specified instance, with
         *        the exception of the block device mapping.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Create an
         *        Auto Scaling Group Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the group. This number must be greater than or equal to
         * the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify
         * a desired capacity, the default is the minimum size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the group. This number must be greater than or
         *        equal to the minimum size of the group and less than or equal to the maximum size of the group. If you
         *        do not specify a desired capacity, the default is the minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * The default is 300.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param defaultCooldown
         *        The amount of time, in seconds, after a scaling activity completes before another scaling activity can
         *        start. The default is 300.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * One or more Availability Zones for the group. This parameter is optional if you specify one or more subnets.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group. This parameter is optional if you specify one or more
         *        subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones for the group. This parameter is optional if you specify one or more subnets.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group. This parameter is optional if you specify one or more
         *        subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * One or more Classic Load Balancers. To specify an Application Load Balancer, use <code>TargetGroupARNs</code>
         * instead.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a Load
         * Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more Classic Load Balancers. To specify an Application Load Balancer, use
         *        <code>TargetGroupARNs</code> instead.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a
         *        Load Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * One or more Classic Load Balancers. To specify an Application Load Balancer, use <code>TargetGroupARNs</code>
         * instead.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a Load
         * Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more Classic Load Balancers. To specify an Application Load Balancer, use
         *        <code>TargetGroupARNs</code> instead.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-asg-from-instance.html">Using a
         *        Load Balancer With an Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);

        /**
         * <p>
         * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         * </p>
         * <p>
         * By default, health checks use Amazon EC2 instance status checks to determine the health of an instance. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
         * <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>
         *        .</p>
         *        <p>
         *        By default, health checks use Amazon EC2 instance status checks to determine the health of an
         *        instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in
         *        the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance
         * that has come into service. During this time, any health check failures for the instance are ignored. The
         * default is 0.
         * </p>
         * <p>
         * This parameter is required if you are adding an <code>ELB</code> health check.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
         * <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
         *        instance that has come into service. During this time, any health check failures for the instance are
         *        ignored. The default is 0.</p>
         *        <p>
         *        This parameter is required if you are adding an <code>ELB</code> health check.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in
         *        the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param placementGroup
         *        The name of the placement group into which you'll launch your instances, if any. For more information,
         *        see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
         *        Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * A comma-separated list of subnet identifiers for your virtual private cloud (VPC).
         * </p>
         * <p>
         * If you specify subnets and Availability Zones with this call, ensure that the subnets' Availability Zones
         * match the Availability Zones specified.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        A comma-separated list of subnet identifiers for your virtual private cloud (VPC).</p>
         *        <p>
         *        If you specify subnets and Availability Zones with this call, ensure that the subnets' Availability
         *        Zones match the Availability Zones specified.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * One or more termination policies used to select the instance to terminate. These policies are executed in the
         * order that they are listed.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
         * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        One or more termination policies used to select the instance to terminate. These policies are executed
         *        in the order that they are listed.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html"
         *        >Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * One or more termination policies used to select the instance to terminate. These policies are executed in the
         * order that they are listed.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
         * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        One or more termination policies used to select the instance to terminate. These policies are executed
         *        in the order that they are listed.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html"
         *        >Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);

        /**
         * <p>
         * One or more lifecycle hooks.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more lifecycle hooks.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more tags.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling
         * Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto
         *        Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling
         * Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto
         *        Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String launchConfigurationName;

        private String instanceId;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones;

        private List<String> loadBalancerNames;

        private List<String> targetGroupARNs;

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<String> terminationPolicies;

        private Boolean newInstancesProtectedFromScaleIn;

        private List<LifecycleHookSpecification> lifecycleHookSpecificationList;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            launchConfigurationName(model.launchConfigurationName);
            instanceId(model.instanceId);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            defaultCooldown(model.defaultCooldown);
            availabilityZones(model.availabilityZones);
            loadBalancerNames(model.loadBalancerNames);
            targetGroupARNs(model.targetGroupARNs);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            placementGroup(model.placementGroup);
            vpcZoneIdentifier(model.vpcZoneIdentifier);
            terminationPolicies(model.terminationPolicies);
            newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            lifecycleHookSpecificationList(model.lifecycleHookSpecificationList);
            tags(model.tags);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            return loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            return targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final Collection<LifecycleHookSpecification.Builder> getLifecycleHookSpecificationList() {
            return lifecycleHookSpecificationList != null ? lifecycleHookSpecificationList.stream()
                    .map(LifecycleHookSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copy(lifecycleHookSpecificationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList) {
            lifecycleHookSpecificationList(Arrays.asList(lifecycleHookSpecificationList));
            return this;
        }

        public final void setLifecycleHookSpecificationList(
                Collection<LifecycleHookSpecification.BuilderImpl> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier
                    .copyFromBuilder(lifecycleHookSpecificationList);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }
    }
}
