/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateLaunchConfigurationRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CreateLaunchConfigurationRequest.Builder, CreateLaunchConfigurationRequest> {
    private final String launchConfigurationName;

    private final String imageId;

    private final String keyName;

    private final List<String> securityGroups;

    private final String classicLinkVPCId;

    private final List<String> classicLinkVPCSecurityGroups;

    private final String userData;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String ramdiskId;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final InstanceMonitoring instanceMonitoring;

    private final String spotPrice;

    private final String iamInstanceProfile;

    private final Boolean ebsOptimized;

    private final Boolean associatePublicIpAddress;

    private final String placementTenancy;

    private CreateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationName = builder.launchConfigurationName;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
    }

    /**
     * <p>
     * The name of the launch configuration. This name must be unique within the scope of your AWS account.
     * </p>
     * 
     * @return The name of the launch configuration. This name must be unique within the scope of your AWS account.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the key pair. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The name of the key pair. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * One or more security groups with which to associate the instances.
     * </p>
     * <p>
     * If your instances are launched in EC2-Classic, you can either specify security group names or the security group
     * IDs. For more information about security groups for EC2-Classic, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
     * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups with which to associate the instances.</p>
     *         <p>
     *         If your instances are launched in EC2-Classic, you can either specify security group names or the
     *         security group IDs. For more information about security groups for EC2-Classic, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
     *         Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     *         <p>
     *         If your instances are launched into a VPC, specify security group IDs. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for
     *         Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported only if
     * you are launching EC2-Classic instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported
     *         only if you are launching EC2-Classic instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String classicLinkVPCId() {
        return classicLinkVPCId;
    }

    /**
     * <p>
     * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required if
     * you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
     *         required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<String> classicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups;
    }

    /**
     * <p>
     * The user data to make available to the launched EC2 instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The user data to make available to the launched EC2 instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes
     * from the instance, with the exception of the block device mapping.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
     * <code>InstanceType</code>.
     * </p>
     * <p>
     * To create a launch configuration with a block device mapping or override any other instance attributes, specify
     * them as part of the same request.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a Launch
     * Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance to use to create the launch configuration. The new launch configuration derives
     *         attributes from the instance, with the exception of the block device mapping.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
     *         <code>InstanceType</code>.
     *         </p>
     *         <p>
     *         To create a launch configuration with a block device mapping or override any other instance attributes,
     *         specify them as part of the same request.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a
     *         Launch Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type of the EC2 instance.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
     * </p>
     * <p>
     * For information about available instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     * </p>
     * 
     * @return The instance type of the EC2 instance.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
     *         </p>
     *         <p>
     *         For information about available instance types, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
     *         >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel associated with the AMI.
     * </p>
     * 
     * @return The ID of the kernel associated with the AMI.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The ID of the RAM disk associated with the AMI.
     * </p>
     * 
     * @return The ID of the RAM disk associated with the AMI.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
     * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more mappings that specify how block devices are exposed to the instance. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
     *         Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling
     * instances. The default is <code>true</code>.
     * </p>
     * 
     * @return Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto
     *         Scaling instances. The default is <code>true</code>.
     */
    public InstanceMonitoring instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
     * launched when the price you specify exceeds the current Spot market price. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot Instances in
     * Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances
     *         are launched when the price you specify exceeds the current Spot market price. For more information, see
     *         <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot
     *         Instances in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * </p>
     * <p>
     * EC2 instances launched with an IAM role will automatically have AWS security credentials available. You can use
     * IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to securely access
     * other AWS resources. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling Instances
     * with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
     *         instance.</p>
     *         <p>
     *         EC2 instances launched with an IAM role will automatically have AWS security credentials available. You
     *         can use IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to
     *         securely access other AWS resources. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling
     *         Instances with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized for EBS
     * I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide
     * optimal I/O performance. This optimization is not available with all instance types. Additional usage charges
     * apply. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized
     *         for EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration
     *         stack to provide optimal I/O performance. This optimization is not available with all instance types.
     *         Additional usage charges apply. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
     *         Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a public IP
     * address to each instance. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you specify this parameter, be sure to specify at least one subnet when you create your group.
     * </p>
     * <p>
     * Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the instance is
     * launched into a nondefault subnet, the default is <code>false</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a
     *         public IP address to each instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>
     *         <p>
     *         If you specify this parameter, be sure to specify at least one subnet when you create your group.
     *         </p>
     *         <p>
     *         Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the
     *         instance is launched into a nondefault subnet, the default is <code>false</code>. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware
     * and can only be launched into a VPC.
     * </p>
     * <p>
     * You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances into a
     * shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
     * </p>
     * <p>
     * If you specify this parameter, be sure to specify at least one subnet when you create your group.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>default</code> | <code>dedicated</code>
     * </p>
     * 
     * @return The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
     *         hardware and can only be launched into a VPC.</p>
     *         <p>
     *         You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances
     *         into a shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
     *         </p>
     *         <p>
     *         If you specify this parameter, be sure to specify at least one subnet when you create your group.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         Valid values: <code>default</code> | <code>dedicated</code>
     */
    public String placementTenancy() {
        return placementTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVPCSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(placementTenancy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationRequest)) {
            return false;
        }
        CreateLaunchConfigurationRequest other = (CreateLaunchConfigurationRequest) obj;
        return Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(classicLinkVPCId(), other.classicLinkVPCId())
                && Objects.equals(classicLinkVPCSecurityGroups(), other.classicLinkVPCSecurityGroups())
                && Objects.equals(userData(), other.userData()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(instanceMonitoring(), other.instanceMonitoring())
                && Objects.equals(spotPrice(), other.spotPrice())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(placementTenancy(), other.placementTenancy());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (classicLinkVPCId() != null) {
            sb.append("ClassicLinkVPCId: ").append(classicLinkVPCId()).append(",");
        }
        if (classicLinkVPCSecurityGroups() != null) {
            sb.append("ClassicLinkVPCSecurityGroups: ").append(classicLinkVPCSecurityGroups()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (instanceMonitoring() != null) {
            sb.append("InstanceMonitoring: ").append(instanceMonitoring()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(associatePublicIpAddress()).append(",");
        }
        if (placementTenancy() != null) {
            sb.append("PlacementTenancy: ").append(placementTenancy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurationName":
            return Optional.of(clazz.cast(launchConfigurationName()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "SecurityGroups":
            return Optional.of(clazz.cast(securityGroups()));
        case "ClassicLinkVPCId":
            return Optional.of(clazz.cast(classicLinkVPCId()));
        case "ClassicLinkVPCSecurityGroups":
            return Optional.of(clazz.cast(classicLinkVPCSecurityGroups()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "InstanceMonitoring":
            return Optional.of(clazz.cast(instanceMonitoring()));
        case "SpotPrice":
            return Optional.of(clazz.cast(spotPrice()));
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "AssociatePublicIpAddress":
            return Optional.of(clazz.cast(associatePublicIpAddress()));
        case "PlacementTenancy":
            return Optional.of(clazz.cast(placementTenancy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, CreateLaunchConfigurationRequest> {
        /**
         * <p>
         * The name of the launch configuration. This name must be unique within the scope of your AWS account.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration. This name must be unique within the scope of your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the key pair. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * One or more security groups with which to associate the instances.
         * </p>
         * <p>
         * If your instances are launched in EC2-Classic, you can either specify security group names or the security
         * group IDs. For more information about security groups for EC2-Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
         * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
         * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups with which to associate the instances.</p>
         *        <p>
         *        If your instances are launched in EC2-Classic, you can either specify security group names or the
         *        security group IDs. For more information about security groups for EC2-Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2
         *        Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * One or more security groups with which to associate the instances.
         * </p>
         * <p>
         * If your instances are launched in EC2-Classic, you can either specify security group names or the security
         * group IDs. For more information about security groups for EC2-Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
         * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
         * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups with which to associate the instances.</p>
         *        <p>
         *        If your instances are launched in EC2-Classic, you can either specify security group names or the
         *        security group IDs. For more information about security groups for EC2-Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2
         *        Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported only
         * if you are launching EC2-Classic instances. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCId
         *        The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported
         *        only if you are launching EC2-Classic instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCId(String classicLinkVPCId);

        /**
         * <p>
         * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required
         * if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
         *        required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required
         * if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
         *        required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The user data to make available to the launched EC2 instances. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the launched EC2 instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
         *        and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The ID of the instance to use to create the launch configuration. The new launch configuration derives
         * attributes from the instance, with the exception of the block device mapping.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
         * <code>InstanceType</code>.
         * </p>
         * <p>
         * To create a launch configuration with a block device mapping or override any other instance attributes,
         * specify them as part of the same request.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a Launch
         * Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to use to create the launch configuration. The new launch configuration derives
         *        attributes from the instance, with the exception of the block device mapping.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
         *        <code>InstanceType</code>.
         *        </p>
         *        <p>
         *        To create a launch configuration with a block device mapping or override any other instance
         *        attributes, specify them as part of the same request.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a
         *        Launch Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type of the EC2 instance.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
         * </p>
         * <p>
         * For information about available instance types, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * </p>
         * 
         * @param instanceType
         *        The instance type of the EC2 instance.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
         *        </p>
         *        <p>
         *        For information about available instance types, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel associated with the AMI.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The ID of the RAM disk associated with the AMI.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more mappings that specify how block devices are exposed to the instance. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more mappings that specify how block devices are exposed to the instance. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling
         * instances. The default is <code>true</code>.
         * </p>
         * 
         * @param instanceMonitoring
         *        Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto
         *        Scaling instances. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(InstanceMonitoring instanceMonitoring);

        /**
         * <p>
         * Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling
         * instances. The default is <code>true</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMonitoring.Builder} avoiding the need to
         * create one manually via {@link InstanceMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceMonitoring(InstanceMonitoring)}.
         * 
         * @param instanceMonitoring
         *        a consumer that will call methods on {@link InstanceMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitoring(InstanceMonitoring)
         */
        default Builder instanceMonitoring(Consumer<InstanceMonitoring.Builder> instanceMonitoring) {
            return instanceMonitoring(InstanceMonitoring.builder().apply(instanceMonitoring).build());
        }

        /**
         * <p>
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
         * launched when the price you specify exceeds the current Spot market price. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot Instances
         * in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param spotPrice
         *        The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot
         *        Instances are launched when the price you specify exceeds the current Spot market price. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot
         *        Instances in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
         * instance.
         * </p>
         * <p>
         * EC2 instances launched with an IAM role will automatically have AWS security credentials available. You can
         * use IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to
         * securely access other AWS resources. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling Instances
         * with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for
         *        the instance.</p>
         *        <p>
         *        EC2 instances launched with an IAM role will automatically have AWS security credentials available.
         *        You can use IAM roles with Auto Scaling to automatically enable applications running on your EC2
         *        instances to securely access other AWS resources. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling
         *        Instances with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized for
         * EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal I/O performance. This optimization is not available with all instance types. Additional usage
         * charges apply. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not
         *        optimized for EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized
         *        configuration stack to provide optimal I/O performance. This optimization is not available with all
         *        instance types. Additional usage charges apply. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         *        Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a
         * public IP address to each instance. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * If you specify this parameter, be sure to specify at least one subnet when you create your group.
         * </p>
         * <p>
         * Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the instance
         * is launched into a nondefault subnet, the default is <code>false</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign
         *        a public IP address to each instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>
         *        <p>
         *        If you specify this parameter, be sure to specify at least one subnet when you create your group.
         *        </p>
         *        <p>
         *        Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the
         *        instance is launched into a nondefault subnet, the default is <code>false</code>. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
         * hardware and can only be launched into a VPC.
         * </p>
         * <p>
         * You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances into
         * a shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
         * </p>
         * <p>
         * If you specify this parameter, be sure to specify at least one subnet when you create your group.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>default</code> | <code>dedicated</code>
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on
         *        single-tenant hardware and can only be launched into a VPC.</p>
         *        <p>
         *        You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated
         *        Instances into a shared tenancy VPC (VPC with instance placement tenancy attribute set to
         *        <code>default</code>).
         *        </p>
         *        <p>
         *        If you specify this parameter, be sure to specify at least one subnet when you create your group.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        Valid values: <code>default</code> | <code>dedicated</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String launchConfigurationName;

        private String imageId;

        private String keyName;

        private List<String> securityGroups;

        private String classicLinkVPCId;

        private List<String> classicLinkVPCSecurityGroups;

        private String userData;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String ramdiskId;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private InstanceMonitoring instanceMonitoring;

        private String spotPrice;

        private String iamInstanceProfile;

        private Boolean ebsOptimized;

        private Boolean associatePublicIpAddress;

        private String placementTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationRequest model) {
            launchConfigurationName(model.launchConfigurationName);
            imageId(model.imageId);
            keyName(model.keyName);
            securityGroups(model.securityGroups);
            classicLinkVPCId(model.classicLinkVPCId);
            classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            userData(model.userData);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            blockDeviceMappings(model.blockDeviceMappings);
            instanceMonitoring(model.instanceMonitoring);
            spotPrice(model.spotPrice);
            iamInstanceProfile(model.iamInstanceProfile);
            ebsOptimized(model.ebsOptimized);
            associatePublicIpAddress(model.associatePublicIpAddress);
            placementTenancy(model.placementTenancy);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return instanceMonitoring != null ? instanceMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchConfigurationRequest build() {
            return new CreateLaunchConfigurationRequest(this);
        }
    }
}
