/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DeleteAutoScalingGroupRequest.Builder, DeleteAutoScalingGroupRequest> {
    private final String autoScalingGroupName;

    private final Boolean forceDelete;

    private DeleteAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The name of the group to delete.
     * </p>
     * 
     * @return The name of the group to delete.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Specifies that the group will be deleted along with all instances associated with the group, without waiting for
     * all instances to be terminated. This parameter also deletes any lifecycle actions associated with the group.
     * </p>
     * 
     * @return Specifies that the group will be deleted along with all instances associated with the group, without
     *         waiting for all instances to be terminated. This parameter also deletes any lifecycle actions associated
     *         with the group.
     */
    public Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutoScalingGroupRequest)) {
            return false;
        }
        DeleteAutoScalingGroupRequest other = (DeleteAutoScalingGroupRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(forceDelete(), other.forceDelete());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (forceDelete() != null) {
            sb.append("ForceDelete: ").append(forceDelete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ForceDelete":
            return Optional.of(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DeleteAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the group to delete.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Specifies that the group will be deleted along with all instances associated with the group, without waiting
         * for all instances to be terminated. This parameter also deletes any lifecycle actions associated with the
         * group.
         * </p>
         * 
         * @param forceDelete
         *        Specifies that the group will be deleted along with all instances associated with the group, without
         *        waiting for all instances to be terminated. This parameter also deletes any lifecycle actions
         *        associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutoScalingGroupRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            forceDelete(model.forceDelete);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutoScalingGroupRequest build() {
            return new DeleteAutoScalingGroupRequest(this);
        }
    }
}
