/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAdjustmentTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAdjustmentTypesResponse.Builder, DescribeAdjustmentTypesResponse> {
    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    /**
     * <p>
     * The policy adjustment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The policy adjustment types.
     */
    public List<AdjustmentType> adjustmentTypes() {
        return adjustmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse) obj;
        return Objects.equals(adjustmentTypes(), other.adjustmentTypes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (adjustmentTypes() != null) {
            sb.append("AdjustmentTypes: ").append(adjustmentTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdjustmentTypes":
            return Optional.of(clazz.cast(adjustmentTypes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes);

        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(AdjustmentType... adjustmentTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<AdjustmentType> adjustmentTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            adjustmentTypes(model.adjustmentTypes);
        }

        public final Collection<AdjustmentType.Builder> getAdjustmentTypes() {
            return adjustmentTypes != null ? adjustmentTypes.stream().map(AdjustmentType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType... adjustmentTypes) {
            adjustmentTypes(Arrays.asList(adjustmentTypes));
            return this;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType.BuilderImpl> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copyFromBuilder(adjustmentTypes);
        }

        @Override
        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }
    }
}
