/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLifecycleHooksRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeLifecycleHooksRequest.Builder, DescribeLifecycleHooksRequest> {
    private final String autoScalingGroupName;

    private final List<String> lifecycleHookNames;

    private DescribeLifecycleHooksRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleHookNames = builder.lifecycleHookNames;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
     */
    public List<String> lifecycleHookNames() {
        return lifecycleHookNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksRequest)) {
            return false;
        }
        DescribeLifecycleHooksRequest other = (DescribeLifecycleHooksRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(lifecycleHookNames(), other.lifecycleHookNames());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (lifecycleHookNames() != null) {
            sb.append("LifecycleHookNames: ").append(lifecycleHookNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "LifecycleHookNames":
            return Optional.of(clazz.cast(lifecycleHookNames()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
         * </p>
         * 
         * @param lifecycleHookNames
         *        The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookNames(Collection<String> lifecycleHookNames);

        /**
         * <p>
         * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
         * </p>
         * 
         * @param lifecycleHookNames
         *        The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookNames(String... lifecycleHookNames);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> lifecycleHookNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            lifecycleHookNames(model.lifecycleHookNames);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getLifecycleHookNames() {
            return lifecycleHookNames;
        }

        @Override
        public final Builder lifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookNames(String... lifecycleHookNames) {
            lifecycleHookNames(Arrays.asList(lifecycleHookNames));
            return this;
        }

        public final void setLifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeLifecycleHooksRequest build() {
            return new DescribeLifecycleHooksRequest(this);
        }
    }
}
