/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePoliciesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribePoliciesResponse.Builder, DescribePoliciesResponse> {
    private final List<ScalingPolicy> scalingPolicies;

    private final String nextToken;

    private DescribePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scaling policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scaling policies.
     */
    public List<ScalingPolicy> scalingPolicies() {
        return scalingPolicies;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalingPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesResponse)) {
            return false;
        }
        DescribePoliciesResponse other = (DescribePoliciesResponse) obj;
        return Objects.equals(scalingPolicies(), other.scalingPolicies()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (scalingPolicies() != null) {
            sb.append("ScalingPolicies: ").append(scalingPolicies()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPolicies":
            return Optional.of(clazz.cast(scalingPolicies()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribePoliciesResponse> {
        /**
         * <p>
         * The scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        The scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies);

        /**
         * <p>
         * The scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        The scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(ScalingPolicy... scalingPolicies);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<ScalingPolicy> scalingPolicies;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesResponse model) {
            scalingPolicies(model.scalingPolicies);
            nextToken(model.nextToken);
        }

        public final Collection<ScalingPolicy.Builder> getScalingPolicies() {
            return scalingPolicies != null ? scalingPolicies.stream().map(ScalingPolicy::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy... scalingPolicies) {
            scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePoliciesResponse build() {
            return new DescribePoliciesResponse(this);
        }
    }
}
