/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledActionsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;

    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scheduled actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scheduled actions.
     */
    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return scheduledUpdateGroupActions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledUpdateGroupActions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        return Objects.equals(scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (scheduledUpdateGroupActions() != null) {
            sb.append("ScheduledUpdateGroupActions: ").append(scheduledUpdateGroupActions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledUpdateGroupActions":
            return Optional.of(clazz.cast(scheduledUpdateGroupActions()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * The scheduled actions.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions);

        /**
         * <p>
         * The scheduled actions.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            nextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction.Builder> getScheduledUpdateGroupActions() {
            return scheduledUpdateGroupActions != null ? scheduledUpdateGroupActions.stream()
                    .map(ScheduledUpdateGroupAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions) {
            scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        public final void setScheduledUpdateGroupActions(
                Collection<ScheduledUpdateGroupAction.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }
    }
}
