/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EnableMetricsCollectionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<EnableMetricsCollectionRequest.Builder, EnableMetricsCollectionRequest> {
    private final String autoScalingGroupName;

    private final List<String> metrics;

    private final String granularity;

    private EnableMetricsCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.metrics = builder.metrics;
        this.granularity = builder.granularity;
    }

    /**
     * <p>
     * The name or ARN of the Auto Scaling group.
     * </p>
     * 
     * @return The name or ARN of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more of the following metrics. If you omit this parameter, all metrics are enabled.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GroupMinSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupMaxSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalInstances</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more of the following metrics. If you omit this parameter, all metrics are enabled.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GroupMinSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupMaxSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalInstances</code>
     *         </p>
     *         </li>
     */
    public List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.
     * </p>
     * 
     * @return The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.
     */
    public String granularity() {
        return granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(granularity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMetricsCollectionRequest)) {
            return false;
        }
        EnableMetricsCollectionRequest other = (EnableMetricsCollectionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(granularity(), other.granularity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (metrics() != null) {
            sb.append("Metrics: ").append(metrics()).append(",");
        }
        if (granularity() != null) {
            sb.append("Granularity: ").append(granularity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "Metrics":
            return Optional.of(clazz.cast(metrics()));
        case "Granularity":
            return Optional.of(clazz.cast(granularity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, EnableMetricsCollectionRequest> {
        /**
         * <p>
         * The name or ARN of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or ARN of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following metrics. If you omit this parameter, all metrics are enabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        One or more of the following metrics. If you omit this parameter, all metrics are enabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * One or more of the following metrics. If you omit this parameter, all metrics are enabled.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metrics
         *        One or more of the following metrics. If you omit this parameter, all metrics are enabled.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.
         * </p>
         * 
         * @param granularity
         *        The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularity(String granularity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> metrics;

        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMetricsCollectionRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            metrics(model.metrics);
            granularity(model.granularity);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        public final String getGranularity() {
            return granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnableMetricsCollectionRequest build() {
            return new EnableMetricsCollectionRequest(this);
        }
    }
}
