/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScheduledUpdateGroupActionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutScheduledUpdateGroupActionRequest.Builder, PutScheduledUpdateGroupActionRequest> {
    private final String autoScalingGroupName;

    private final String scheduledActionName;

    private final Instant time;

    private final Instant startTime;

    private final Instant endTime;

    private final String recurrence;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private PutScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
        this.time = builder.time;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of this scaling action.
     * </p>
     * 
     * @return The name of this scaling action.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * This parameter is deprecated.
     * </p>
     * 
     * @return This parameter is deprecated.
     */
    public Instant time() {
        return time;
    }

    /**
     * <p>
     * The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     * <code>2014-06-01T00:00:00Z</code>).
     * </p>
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at this time,
     * and then performs the action based on the specified recurrence.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Auto Scaling returns an error message.
     * </p>
     * 
     * @return The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     *         <code>2014-06-01T00:00:00Z</code>).</p>
     *         <p>
     *         If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at
     *         this time, and then performs the action based on the specified recurrence.
     *         </p>
     *         <p>
     *         If you try to schedule your action in the past, Auto Scaling returns an error message.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
     * </p>
     * 
     * @return The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
     * href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
     * </p>
     * 
     * @return The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
     *         href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
     */
    public String recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The minimum size for the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size for the Auto Scaling group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size for the Auto Scaling group.
     * </p>
     * 
     * @return The maximum size for the Auto Scaling group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScheduledUpdateGroupActionRequest)) {
            return false;
        }
        PutScheduledUpdateGroupActionRequest other = (PutScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scheduledActionName(), other.scheduledActionName()) && Objects.equals(time(), other.time())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(recurrence(), other.recurrence()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (scheduledActionName() != null) {
            sb.append("ScheduledActionName: ").append(scheduledActionName()).append(",");
        }
        if (time() != null) {
            sb.append("Time: ").append(time()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (recurrence() != null) {
            sb.append("Recurrence: ").append(recurrence()).append(",");
        }
        if (minSize() != null) {
            sb.append("MinSize: ").append(minSize()).append(",");
        }
        if (maxSize() != null) {
            sb.append("MaxSize: ").append(maxSize()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ScheduledActionName":
            return Optional.of(clazz.cast(scheduledActionName()));
        case "Time":
            return Optional.of(clazz.cast(time()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        case "Recurrence":
            return Optional.of(clazz.cast(recurrence()));
        case "MinSize":
            return Optional.of(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.of(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.of(clazz.cast(desiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, PutScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of this scaling action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of this scaling action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * This parameter is deprecated.
         * </p>
         * 
         * @param time
         *        This parameter is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         * <code>2014-06-01T00:00:00Z</code>).
         * </p>
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at this
         * time, and then performs the action based on the specified recurrence.
         * </p>
         * <p>
         * If you try to schedule your action in the past, Auto Scaling returns an error message.
         * </p>
         * 
         * @param startTime
         *        The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         *        <code>2014-06-01T00:00:00Z</code>).</p>
         *        <p>
         *        If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at
         *        this time, and then performs the action based on the specified recurrence.
         *        </p>
         *        <p>
         *        If you try to schedule your action in the past, Auto Scaling returns an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
         * </p>
         * 
         * @param endTime
         *        The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
         * href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
         * </p>
         * 
         * @param recurrence
         *        The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
         *        href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);

        /**
         * <p>
         * The minimum size for the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size for the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String scheduledActionName;

        private Instant time;

        private Instant startTime;

        private Instant endTime;

        private String recurrence;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScheduledUpdateGroupActionRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            scheduledActionName(model.scheduledActionName);
            time(model.time);
            startTime(model.startTime);
            endTime(model.endTime);
            recurrence(model.recurrence);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final Instant getTime() {
            return time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutScheduledUpdateGroupActionRequest build() {
            return new PutScheduledUpdateGroupActionRequest(this);
        }
    }
}
