/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a target tracking policy configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetTrackingConfiguration implements
        ToCopyableBuilder<TargetTrackingConfiguration.Builder, TargetTrackingConfiguration> {
    private final PredefinedMetricSpecification predefinedMetricSpecification;

    private final CustomizedMetricSpecification customizedMetricSpecification;

    private final Double targetValue;

    private final Boolean disableScaleIn;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
    }

    /**
     * <p>
     * A predefined metric. You can specify either a predefined metric or a customized metric.
     * </p>
     * 
     * @return A predefined metric. You can specify either a predefined metric or a customized metric.
     */
    public PredefinedMetricSpecification predefinedMetricSpecification() {
        return predefinedMetricSpecification;
    }

    /**
     * <p>
     * A customized metric.
     * </p>
     * 
     * @return A customized metric.
     */
    public CustomizedMetricSpecification customizedMetricSpecification() {
        return customizedMetricSpecification;
    }

    /**
     * <p>
     * The target value for the metric.
     * </p>
     * 
     * @return The target value for the metric.
     */
    public Double targetValue() {
        return targetValue;
    }

    /**
     * <p>
     * Indicates whether scale in by the target tracking policy is disabled. If the value is <code>true</code>, scale in
     * is disabled and the target tracking policy won't remove instances from the Auto Scaling group. Otherwise, scale
     * in is enabled and the target tracking policy can remove instances from the Auto Scaling group. The default value
     * is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether scale in by the target tracking policy is disabled. If the value is <code>true</code>,
     *         scale in is disabled and the target tracking policy won't remove instances from the Auto Scaling group.
     *         Otherwise, scale in is enabled and the target tracking policy can remove instances from the Auto Scaling
     *         group. The default value is <code>false</code>.
     */
    public Boolean disableScaleIn() {
        return disableScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration) obj;
        return Objects.equals(predefinedMetricSpecification(), other.predefinedMetricSpecification())
                && Objects.equals(customizedMetricSpecification(), other.customizedMetricSpecification())
                && Objects.equals(targetValue(), other.targetValue()) && Objects.equals(disableScaleIn(), other.disableScaleIn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (predefinedMetricSpecification() != null) {
            sb.append("PredefinedMetricSpecification: ").append(predefinedMetricSpecification()).append(",");
        }
        if (customizedMetricSpecification() != null) {
            sb.append("CustomizedMetricSpecification: ").append(customizedMetricSpecification()).append(",");
        }
        if (targetValue() != null) {
            sb.append("TargetValue: ").append(targetValue()).append(",");
        }
        if (disableScaleIn() != null) {
            sb.append("DisableScaleIn: ").append(disableScaleIn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricSpecification":
            return Optional.of(clazz.cast(predefinedMetricSpecification()));
        case "CustomizedMetricSpecification":
            return Optional.of(clazz.cast(customizedMetricSpecification()));
        case "TargetValue":
            return Optional.of(clazz.cast(targetValue()));
        case "DisableScaleIn":
            return Optional.of(clazz.cast(disableScaleIn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TargetTrackingConfiguration> {
        /**
         * <p>
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * 
         * @param predefinedMetricSpecification
         *        A predefined metric. You can specify either a predefined metric or a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification);

        /**
         * <p>
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link PredefinedMetricSpecification.Builder} avoiding
         * the need to create one manually via {@link PredefinedMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredefinedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #predefinedMetricSpecification(PredefinedMetricSpecification)}
         * .
         * 
         * @param predefinedMetricSpecification
         *        a consumer that will call methods on {@link PredefinedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedMetricSpecification(PredefinedMetricSpecification)
         */
        default Builder predefinedMetricSpecification(
                Consumer<PredefinedMetricSpecification.Builder> predefinedMetricSpecification) {
            return predefinedMetricSpecification(PredefinedMetricSpecification.builder().apply(predefinedMetricSpecification)
                    .build());
        }

        /**
         * <p>
         * A customized metric.
         * </p>
         * 
         * @param customizedMetricSpecification
         *        A customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification);

        /**
         * <p>
         * A customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomizedMetricSpecification.Builder} avoiding
         * the need to create one manually via {@link CustomizedMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomizedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #customizedMetricSpecification(CustomizedMetricSpecification)}
         * .
         * 
         * @param customizedMetricSpecification
         *        a consumer that will call methods on {@link CustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedMetricSpecification(CustomizedMetricSpecification)
         */
        default Builder customizedMetricSpecification(
                Consumer<CustomizedMetricSpecification.Builder> customizedMetricSpecification) {
            return customizedMetricSpecification(CustomizedMetricSpecification.builder().apply(customizedMetricSpecification)
                    .build());
        }

        /**
         * <p>
         * The target value for the metric.
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);

        /**
         * <p>
         * Indicates whether scale in by the target tracking policy is disabled. If the value is <code>true</code>,
         * scale in is disabled and the target tracking policy won't remove instances from the Auto Scaling group.
         * Otherwise, scale in is enabled and the target tracking policy can remove instances from the Auto Scaling
         * group. The default value is <code>false</code>.
         * </p>
         * 
         * @param disableScaleIn
         *        Indicates whether scale in by the target tracking policy is disabled. If the value is
         *        <code>true</code>, scale in is disabled and the target tracking policy won't remove instances from the
         *        Auto Scaling group. Otherwise, scale in is enabled and the target tracking policy can remove instances
         *        from the Auto Scaling group. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);
    }

    static final class BuilderImpl implements Builder {
        private PredefinedMetricSpecification predefinedMetricSpecification;

        private CustomizedMetricSpecification customizedMetricSpecification;

        private Double targetValue;

        private Boolean disableScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            predefinedMetricSpecification(model.predefinedMetricSpecification);
            customizedMetricSpecification(model.customizedMetricSpecification);
            targetValue(model.targetValue);
            disableScaleIn(model.disableScaleIn);
        }

        public final PredefinedMetricSpecification.Builder getPredefinedMetricSpecification() {
            return predefinedMetricSpecification != null ? predefinedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification.BuilderImpl predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification != null ? predefinedMetricSpecification.build()
                    : null;
        }

        public final CustomizedMetricSpecification.Builder getCustomizedMetricSpecification() {
            return customizedMetricSpecification != null ? customizedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification.BuilderImpl customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification != null ? customizedMetricSpecification.build()
                    : null;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        @Override
        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }
    }
}
