/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * AutoScalingGroup StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AutoScalingGroupUnmarshaller implements Unmarshaller<AutoScalingGroup, StaxUnmarshallerContext> {

    public AutoScalingGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        AutoScalingGroup.Builder autoScalingGroup = AutoScalingGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> availabilityZones = null;
        java.util.List<String> loadBalancerNames = null;
        java.util.List<String> targetGroupARNs = null;
        java.util.List<Instance> instances = null;
        java.util.List<SuspendedProcess> suspendedProcesses = null;
        java.util.List<EnabledMetric> enabledMetrics = null;
        java.util.List<TagDescription> tags = null;
        java.util.List<String> terminationPolicies = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                autoScalingGroup.availabilityZones(availabilityZones);
                autoScalingGroup.loadBalancerNames(loadBalancerNames);
                autoScalingGroup.targetGroupARNs(targetGroupARNs);
                autoScalingGroup.instances(instances);
                autoScalingGroup.suspendedProcesses(suspendedProcesses);
                autoScalingGroup.enabledMetrics(enabledMetrics);
                autoScalingGroup.tags(tags);
                autoScalingGroup.terminationPolicies(terminationPolicies);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    autoScalingGroup.autoScalingGroupName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AutoScalingGroupARN", targetDepth)) {
                    autoScalingGroup.autoScalingGroupARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                    autoScalingGroup.launchConfigurationName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MinSize", targetDepth)) {
                    autoScalingGroup.minSize(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxSize", targetDepth)) {
                    autoScalingGroup.maxSize(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DesiredCapacity", targetDepth)) {
                    autoScalingGroup.desiredCapacity(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DefaultCooldown", targetDepth)) {
                    autoScalingGroup.defaultCooldown(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    availabilityZones = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                    availabilityZones.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LoadBalancerNames", targetDepth)) {
                    loadBalancerNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("LoadBalancerNames/member", targetDepth)) {
                    loadBalancerNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TargetGroupARNs", targetDepth)) {
                    targetGroupARNs = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("TargetGroupARNs/member", targetDepth)) {
                    targetGroupARNs.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HealthCheckType", targetDepth)) {
                    autoScalingGroup.healthCheckType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HealthCheckGracePeriod", targetDepth)) {
                    autoScalingGroup.healthCheckGracePeriod(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Instances", targetDepth)) {
                    instances = new ArrayList<Instance>();
                    continue;
                }

                if (context.testExpression("Instances/member", targetDepth)) {
                    instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CreatedTime", targetDepth)) {
                    autoScalingGroup.createdTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SuspendedProcesses", targetDepth)) {
                    suspendedProcesses = new ArrayList<SuspendedProcess>();
                    continue;
                }

                if (context.testExpression("SuspendedProcesses/member", targetDepth)) {
                    suspendedProcesses.add(SuspendedProcessUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PlacementGroup", targetDepth)) {
                    autoScalingGroup.placementGroup(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VPCZoneIdentifier", targetDepth)) {
                    autoScalingGroup.vpcZoneIdentifier(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EnabledMetrics", targetDepth)) {
                    enabledMetrics = new ArrayList<EnabledMetric>();
                    continue;
                }

                if (context.testExpression("EnabledMetrics/member", targetDepth)) {
                    enabledMetrics.add(EnabledMetricUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    autoScalingGroup.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Tags", targetDepth)) {
                    tags = new ArrayList<TagDescription>();
                    continue;
                }

                if (context.testExpression("Tags/member", targetDepth)) {
                    tags.add(TagDescriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TerminationPolicies", targetDepth)) {
                    terminationPolicies = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("TerminationPolicies/member", targetDepth)) {
                    terminationPolicies.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NewInstancesProtectedFromScaleIn", targetDepth)) {
                    autoScalingGroup.newInstancesProtectedFromScaleIn(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    autoScalingGroup.availabilityZones(availabilityZones);
                    autoScalingGroup.loadBalancerNames(loadBalancerNames);
                    autoScalingGroup.targetGroupARNs(targetGroupARNs);
                    autoScalingGroup.instances(instances);
                    autoScalingGroup.suspendedProcesses(suspendedProcesses);
                    autoScalingGroup.enabledMetrics(enabledMetrics);
                    autoScalingGroup.tags(tags);
                    autoScalingGroup.terminationPolicies(terminationPolicies);
                    break;
                }
            }
        }
        return autoScalingGroup.build();
    }

    private static final AutoScalingGroupUnmarshaller INSTANCE = new AutoScalingGroupUnmarshaller();

    public static AutoScalingGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}
