/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateAutoScalingGroupRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateAutoScalingGroupRequestMarshaller implements
        Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {

    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {

        if (createAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateAutoScalingGroupRequest> request = new DefaultRequest<CreateAutoScalingGroupRequest>(
                createAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(createAutoScalingGroupRequest.autoScalingGroupName()));
        }

        if (createAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName",
                    StringUtils.fromString(createAutoScalingGroupRequest.launchConfigurationName()));
        }

        if (createAutoScalingGroupRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createAutoScalingGroupRequest.instanceId()));
        }

        if (createAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger(createAutoScalingGroupRequest.minSize()));
        }

        if (createAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger(createAutoScalingGroupRequest.maxSize()));
        }

        if (createAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger(createAutoScalingGroupRequest.desiredCapacity()));
        }

        if (createAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger(createAutoScalingGroupRequest.defaultCooldown()));
        }

        java.util.List<String> availabilityZonesList = createAutoScalingGroupRequest.availabilityZones();

        if (availabilityZonesList != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;

                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue != null) {
                        request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex,
                                StringUtils.fromString(availabilityZonesListValue));
                    }
                    availabilityZonesListIndex++;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }

        java.util.List<String> loadBalancerNamesList = createAutoScalingGroupRequest.loadBalancerNames();

        if (loadBalancerNamesList != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;

                for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                    if (loadBalancerNamesListValue != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex,
                                StringUtils.fromString(loadBalancerNamesListValue));
                    }
                    loadBalancerNamesListIndex++;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }

        java.util.List<String> targetGroupARNsList = createAutoScalingGroupRequest.targetGroupARNs();

        if (targetGroupARNsList != null) {
            if (!targetGroupARNsList.isEmpty()) {
                int targetGroupARNsListIndex = 1;

                for (String targetGroupARNsListValue : targetGroupARNsList) {
                    if (targetGroupARNsListValue != null) {
                        request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex,
                                StringUtils.fromString(targetGroupARNsListValue));
                    }
                    targetGroupARNsListIndex++;
                }
            } else {
                request.addParameter("TargetGroupARNs", "");
            }
        }

        if (createAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString(createAutoScalingGroupRequest.healthCheckType()));
        }

        if (createAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod",
                    StringUtils.fromInteger(createAutoScalingGroupRequest.healthCheckGracePeriod()));
        }

        if (createAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString(createAutoScalingGroupRequest.placementGroup()));
        }

        if (createAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString(createAutoScalingGroupRequest.vpcZoneIdentifier()));
        }

        java.util.List<String> terminationPoliciesList = createAutoScalingGroupRequest.terminationPolicies();

        if (terminationPoliciesList != null) {
            if (!terminationPoliciesList.isEmpty()) {
                int terminationPoliciesListIndex = 1;

                for (String terminationPoliciesListValue : terminationPoliciesList) {
                    if (terminationPoliciesListValue != null) {
                        request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex,
                                StringUtils.fromString(terminationPoliciesListValue));
                    }
                    terminationPoliciesListIndex++;
                }
            } else {
                request.addParameter("TerminationPolicies", "");
            }
        }

        if (createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn",
                    StringUtils.fromBoolean(createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }

        java.util.List<LifecycleHookSpecification> lifecycleHookSpecificationListList = createAutoScalingGroupRequest
                .lifecycleHookSpecificationList();

        if (lifecycleHookSpecificationListList != null) {
            if (!lifecycleHookSpecificationListList.isEmpty()) {
                int lifecycleHookSpecificationListListIndex = 1;

                for (LifecycleHookSpecification lifecycleHookSpecificationListListValue : lifecycleHookSpecificationListList) {

                    if (lifecycleHookSpecificationListListValue.lifecycleHookName() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".LifecycleHookName",
                                StringUtils.fromString(lifecycleHookSpecificationListListValue.lifecycleHookName()));
                    }

                    if (lifecycleHookSpecificationListListValue.lifecycleTransition() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".LifecycleTransition",
                                StringUtils.fromString(lifecycleHookSpecificationListListValue.lifecycleTransition()));
                    }

                    if (lifecycleHookSpecificationListListValue.notificationMetadata() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".NotificationMetadata",
                                StringUtils.fromString(lifecycleHookSpecificationListListValue.notificationMetadata()));
                    }

                    if (lifecycleHookSpecificationListListValue.heartbeatTimeout() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".HeartbeatTimeout",
                                StringUtils.fromInteger(lifecycleHookSpecificationListListValue.heartbeatTimeout()));
                    }

                    if (lifecycleHookSpecificationListListValue.defaultResult() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".DefaultResult",
                                StringUtils.fromString(lifecycleHookSpecificationListListValue.defaultResult()));
                    }

                    if (lifecycleHookSpecificationListListValue.notificationTargetARN() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".NotificationTargetARN",
                                StringUtils.fromString(lifecycleHookSpecificationListListValue.notificationTargetARN()));
                    }

                    if (lifecycleHookSpecificationListListValue.roleARN() != null) {
                        request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                                + ".RoleARN", StringUtils.fromString(lifecycleHookSpecificationListListValue.roleARN()));
                    }
                    lifecycleHookSpecificationListListIndex++;
                }
            } else {
                request.addParameter("LifecycleHookSpecificationList", "");
            }
        }

        java.util.List<Tag> tagsList = createAutoScalingGroupRequest.tags();

        if (tagsList != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;

                for (Tag tagsListValue : tagsList) {

                    if (tagsListValue.resourceId() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".ResourceId",
                                StringUtils.fromString(tagsListValue.resourceId()));
                    }

                    if (tagsListValue.resourceType() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".ResourceType",
                                StringUtils.fromString(tagsListValue.resourceType()));
                    }

                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.key()));
                    }

                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value",
                                StringUtils.fromString(tagsListValue.value()));
                    }

                    if (tagsListValue.propagateAtLaunch() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch",
                                StringUtils.fromBoolean(tagsListValue.propagateAtLaunch()));
                    }
                    tagsListIndex++;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }

        return request;
    }

}
