/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeScalingProcessTypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScalingProcessTypesResponseUnmarshaller implements
        Unmarshaller<DescribeScalingProcessTypesResponse, StaxUnmarshallerContext> {

    public DescribeScalingProcessTypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeScalingProcessTypesResponse.Builder describeScalingProcessTypesResponse = DescribeScalingProcessTypesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<ProcessType> processes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeScalingProcessTypesResponse.processes(processes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Processes", targetDepth)) {
                    processes = new ArrayList<ProcessType>();
                    continue;
                }

                if (context.testExpression("Processes/member", targetDepth)) {
                    processes.add(ProcessTypeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeScalingProcessTypesResponse.processes(processes);
                    break;
                }
            }
        }
        return describeScalingProcessTypesResponse.build();
    }

    private static final DescribeScalingProcessTypesResponseUnmarshaller INSTANCE = new DescribeScalingProcessTypesResponseUnmarshaller();

    public static DescribeScalingProcessTypesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
