/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DetachInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DetachInstancesRequestMarshaller implements Marshaller<Request<DetachInstancesRequest>, DetachInstancesRequest> {

    public Request<DetachInstancesRequest> marshall(DetachInstancesRequest detachInstancesRequest) {

        if (detachInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DetachInstancesRequest> request = new DefaultRequest<DetachInstancesRequest>(detachInstancesRequest,
                "AutoScalingClient");
        request.addParameter("Action", "DetachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> instanceIdsList = detachInstancesRequest.instanceIds();

        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;

                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex,
                                StringUtils.fromString(instanceIdsListValue));
                    }
                    instanceIdsListIndex++;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }

        if (detachInstancesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(detachInstancesRequest.autoScalingGroupName()));
        }

        if (detachInstancesRequest.shouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity",
                    StringUtils.fromBoolean(detachInstancesRequest.shouldDecrementDesiredCapacity()));
        }

        return request;
    }

}
