/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ExecutePolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ExecutePolicyRequestMarshaller implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {

    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {

        if (executePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ExecutePolicyRequest> request = new DefaultRequest<ExecutePolicyRequest>(executePolicyRequest,
                "AutoScalingClient");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (executePolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(executePolicyRequest.autoScalingGroupName()));
        }

        if (executePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(executePolicyRequest.policyName()));
        }

        if (executePolicyRequest.honorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean(executePolicyRequest.honorCooldown()));
        }

        if (executePolicyRequest.metricValue() != null) {
            request.addParameter("MetricValue", StringUtils.fromDouble(executePolicyRequest.metricValue()));
        }

        if (executePolicyRequest.breachThreshold() != null) {
            request.addParameter("BreachThreshold", StringUtils.fromDouble(executePolicyRequest.breachThreshold()));
        }

        return request;
    }

}
