/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ExitStandbyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ExitStandbyRequestMarshaller implements Marshaller<Request<ExitStandbyRequest>, ExitStandbyRequest> {

    public Request<ExitStandbyRequest> marshall(ExitStandbyRequest exitStandbyRequest) {

        if (exitStandbyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ExitStandbyRequest> request = new DefaultRequest<ExitStandbyRequest>(exitStandbyRequest, "AutoScalingClient");
        request.addParameter("Action", "ExitStandby");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> instanceIdsList = exitStandbyRequest.instanceIds();

        if (instanceIdsList != null) {
            if (!instanceIdsList.isEmpty()) {
                int instanceIdsListIndex = 1;

                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue != null) {
                        request.addParameter("InstanceIds.member." + instanceIdsListIndex,
                                StringUtils.fromString(instanceIdsListValue));
                    }
                    instanceIdsListIndex++;
                }
            } else {
                request.addParameter("InstanceIds", "");
            }
        }

        if (exitStandbyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(exitStandbyRequest.autoScalingGroupName()));
        }

        return request;
    }

}
