/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutNotificationConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutNotificationConfigurationRequestMarshaller implements
        Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {

    public Request<PutNotificationConfigurationRequest> marshall(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) {

        if (putNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutNotificationConfigurationRequest> request = new DefaultRequest<PutNotificationConfigurationRequest>(
                putNotificationConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putNotificationConfigurationRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(putNotificationConfigurationRequest.autoScalingGroupName()));
        }

        if (putNotificationConfigurationRequest.topicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString(putNotificationConfigurationRequest.topicARN()));
        }

        java.util.List<String> notificationTypesList = putNotificationConfigurationRequest.notificationTypes();

        if (notificationTypesList != null) {
            if (!notificationTypesList.isEmpty()) {
                int notificationTypesListIndex = 1;

                for (String notificationTypesListValue : notificationTypesList) {
                    if (notificationTypesListValue != null) {
                        request.addParameter("NotificationTypes.member." + notificationTypesListIndex,
                                StringUtils.fromString(notificationTypesListValue));
                    }
                    notificationTypesListIndex++;
                }
            } else {
                request.addParameter("NotificationTypes", "");
            }
        }

        return request;
    }

}
