/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutScalingPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScalingPolicyRequestMarshaller implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {

    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {

        if (putScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutScalingPolicyRequest> request = new DefaultRequest<PutScalingPolicyRequest>(putScalingPolicyRequest,
                "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putScalingPolicyRequest.autoScalingGroupName()));
        }

        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(putScalingPolicyRequest.policyName()));
        }

        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringUtils.fromString(putScalingPolicyRequest.policyType()));
        }

        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringUtils.fromString(putScalingPolicyRequest.adjustmentType()));
        }

        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringUtils.fromInteger(putScalingPolicyRequest.minAdjustmentStep()));
        }

        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude",
                    StringUtils.fromInteger(putScalingPolicyRequest.minAdjustmentMagnitude()));
        }

        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringUtils.fromInteger(putScalingPolicyRequest.scalingAdjustment()));
        }

        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringUtils.fromInteger(putScalingPolicyRequest.cooldown()));
        }

        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringUtils.fromString(putScalingPolicyRequest.metricAggregationType()));
        }

        java.util.List<StepAdjustment> stepAdjustmentsList = putScalingPolicyRequest.stepAdjustments();

        if (stepAdjustmentsList != null) {
            if (!stepAdjustmentsList.isEmpty()) {
                int stepAdjustmentsListIndex = 1;

                for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {

                    if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound",
                                StringUtils.fromDouble(stepAdjustmentsListValue.metricIntervalLowerBound()));
                    }

                    if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound",
                                StringUtils.fromDouble(stepAdjustmentsListValue.metricIntervalUpperBound()));
                    }

                    if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                        request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment",
                                StringUtils.fromInteger(stepAdjustmentsListValue.scalingAdjustment()));
                    }
                    stepAdjustmentsListIndex++;
                }
            } else {
                request.addParameter("StepAdjustments", "");
            }
        }

        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup",
                    StringUtils.fromInteger(putScalingPolicyRequest.estimatedInstanceWarmup()));
        }

        TargetTrackingConfiguration targetTrackingConfiguration = putScalingPolicyRequest.targetTrackingConfiguration();
        if (targetTrackingConfiguration != null) {

            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration
                    .predefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {

                if (predefinedMetricSpecification.predefinedMetricTypeString() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType",
                            StringUtils.fromString(predefinedMetricSpecification.predefinedMetricTypeString()));
                }

                if (predefinedMetricSpecification.resourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel",
                            StringUtils.fromString(predefinedMetricSpecification.resourceLabel()));
                }
            }

            CustomizedMetricSpecification customizedMetricSpecification = targetTrackingConfiguration
                    .customizedMetricSpecification();
            if (customizedMetricSpecification != null) {

                if (customizedMetricSpecification.metricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName",
                            StringUtils.fromString(customizedMetricSpecification.metricName()));
                }

                if (customizedMetricSpecification.namespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace",
                            StringUtils.fromString(customizedMetricSpecification.namespace()));
                }

                java.util.List<MetricDimension> dimensionsList = customizedMetricSpecification.dimensions();

                if (dimensionsList != null) {
                    if (!dimensionsList.isEmpty()) {
                        int dimensionsListIndex = 1;

                        for (MetricDimension dimensionsListValue : dimensionsList) {

                            if (dimensionsListValue.name() != null) {
                                request.addParameter(
                                        "TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member."
                                                + dimensionsListIndex + ".Name",
                                        StringUtils.fromString(dimensionsListValue.name()));
                            }

                            if (dimensionsListValue.value() != null) {
                                request.addParameter(
                                        "TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member."
                                                + dimensionsListIndex + ".Value",
                                        StringUtils.fromString(dimensionsListValue.value()));
                            }
                            dimensionsListIndex++;
                        }
                    } else {
                        request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions", "");
                    }
                }

                if (customizedMetricSpecification.statisticString() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic",
                            StringUtils.fromString(customizedMetricSpecification.statisticString()));
                }

                if (customizedMetricSpecification.unit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit",
                            StringUtils.fromString(customizedMetricSpecification.unit()));
                }
            }

            if (targetTrackingConfiguration.targetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue",
                        StringUtils.fromDouble(targetTrackingConfiguration.targetValue()));
            }

            if (targetTrackingConfiguration.disableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn",
                        StringUtils.fromBoolean(targetTrackingConfiguration.disableScaleIn()));
            }
        }

        return request;
    }

}
