/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecificationsCopier;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.Tag;
import software.amazon.awssdk.services.autoscaling.model.TagsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
    private final String autoScalingGroupName;
    private final String launchConfigurationName;
    private final String instanceId;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupARNs;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final List<LifecycleHookSpecification> lifecycleHookSpecificationList;
    private final List<Tag> tags;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
        this.tags = builder.tags;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public List<LifecycleHookSpecification> lifecycleHookSpecificationList() {
        return this.lifecycleHookSpecificationList;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookSpecificationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn()) && Objects.equals(this.lifecycleHookSpecificationList(), other.lifecycleHookSpecificationList()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.launchConfigurationName()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.minSize() != null) {
            sb.append("MinSize: ").append(this.minSize()).append(",");
        }
        if (this.maxSize() != null) {
            sb.append("MaxSize: ").append(this.maxSize()).append(",");
        }
        if (this.desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(this.desiredCapacity()).append(",");
        }
        if (this.defaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(this.defaultCooldown()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        if (this.targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(this.targetGroupARNs()).append(",");
        }
        if (this.healthCheckType() != null) {
            sb.append("HealthCheckType: ").append(this.healthCheckType()).append(",");
        }
        if (this.healthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(this.healthCheckGracePeriod()).append(",");
        }
        if (this.placementGroup() != null) {
            sb.append("PlacementGroup: ").append(this.placementGroup()).append(",");
        }
        if (this.vpcZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(this.vpcZoneIdentifier()).append(",");
        }
        if (this.terminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(this.terminationPolicies()).append(",");
        }
        if (this.newInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(this.newInstancesProtectedFromScaleIn()).append(",");
        }
        if (this.lifecycleHookSpecificationList() != null) {
            sb.append("LifecycleHookSpecificationList: ").append(this.lifecycleHookSpecificationList()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "LaunchConfigurationName": {
                return Optional.of(clazz.cast(this.launchConfigurationName()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "MinSize": {
                return Optional.of(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.of(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.of(clazz.cast(this.desiredCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.of(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "LoadBalancerNames": {
                return Optional.of(clazz.cast(this.loadBalancerNames()));
            }
            case "TargetGroupARNs": {
                return Optional.of(clazz.cast(this.targetGroupARNs()));
            }
            case "HealthCheckType": {
                return Optional.of(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.of(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "PlacementGroup": {
                return Optional.of(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.of(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "TerminationPolicies": {
                return Optional.of(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.of(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
            case "LifecycleHookSpecificationList": {
                return Optional.of(clazz.cast(this.lifecycleHookSpecificationList()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String launchConfigurationName;
        private String instanceId;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones;
        private List<String> loadBalancerNames;
        private List<String> targetGroupARNs;
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<String> terminationPolicies;
        private Boolean newInstancesProtectedFromScaleIn;
        private List<LifecycleHookSpecification> lifecycleHookSpecificationList;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.launchConfigurationName(model.launchConfigurationName);
            this.instanceId(model.instanceId);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.loadBalancerNames(model.loadBalancerNames);
            this.targetGroupARNs(model.targetGroupARNs);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.lifecycleHookSpecificationList(model.lifecycleHookSpecificationList);
            this.tags(model.tags);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final Collection<LifecycleHookSpecification.Builder> getLifecycleHookSpecificationList() {
            return this.lifecycleHookSpecificationList != null ? (Collection)this.lifecycleHookSpecificationList.stream().map(LifecycleHookSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copy(lifecycleHookSpecificationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(LifecycleHookSpecification ... lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList(Arrays.asList(lifecycleHookSpecificationList));
            return this;
        }

        public final void setLifecycleHookSpecificationList(Collection<LifecycleHookSpecification.BuilderImpl> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copyFromBuilder(lifecycleHookSpecificationList);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder instanceId(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> var1);

        public Builder lifecycleHookSpecificationList(LifecycleHookSpecification ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

